<?php
if(function_exists("register_field_group"))
{
	register_field_group(array (
		'id' => 'acf_about-fields',
		'title' => 'About Fields',
		'fields' => array (
			array (
				'key' => 'field_52370b73ac6c8',
				'label' => 'About Titles',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_52370b99ac6c9',
				'label' => 'Page Title',
				'name' => 'introduction',
				'type' => 'text',
				'instructions' => 'Add text to display as page title',
				'default_value' => 'Introduction',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_523eccdf1c8b1',
				'label' => 'Gallery',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_52370beaac6ca',
				'label' => 'Gallery_title',
				'name' => 'gallery_title',
				'type' => 'text',
				'instructions' => 'Add text which will be displayed above the gallery',
				'default_value' => 'Gallery',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_523ecd489401f',
				'label' => 'Gallery items',
				'name' => 'gallery_items',
				'type' => 'repeater',
				'sub_fields' => array (
					array (
						'key' => 'field_523ecd7794020',
						'label' => 'G_Image',
						'name' => 'g_image',
						'type' => 'image',
						'column_width' => '',
						'save_format' => 'id',
						'preview_size' => 'home2-featured',
						'library' => 'all',
					),
				),
				'row_min' => 0,
				'row_limit' => '',
				'layout' => 'table',
				'button_label' => 'Add Row',
			),
			array (
				'key' => 'field_52370c0e236b5',
				'label' => 'Team',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_52370c23236b6',
				'label' => 'Team Title',
				'name' => 'team_title',
				'type' => 'text',
				'instructions' => 'Display the Team section title',
				'default_value' => 'Our team',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_52370c48236b7',
				'label' => 'Team',
				'name' => 'team',
				'type' => 'repeater',
				'instructions' => 'Add as many team members as you want',
				'sub_fields' => array (
					array (
						'key' => 'field_52370c77236b8',
						'label' => 'Image',
						'name' => 'image',
						'type' => 'image',
						'column_width' => '',
						'save_format' => 'id',
						'preview_size' => 'our-team',
						'library' => 'all',
					),
					array (
						'key' => 'field_52370ca6236b9',
						'label' => 'Full Name',
						'name' => 'full_name',
						'type' => 'text',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => '',
					),
					array (
						'key' => 'field_52370cb6236ba',
						'label' => 'Position',
						'name' => 'position',
						'type' => 'text',
						'instructions' => 'Add team member position',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => '',
					),
					array (
						'key' => 'field_53199d31905c2',
						'label' => 'Link',
						'name' => 'link',
						'type' => 'text',
						'instructions' => 'Add a link for team member',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => '',
					),
					array (
						'key' => 'field_52370cc9236bb',
						'label' => 'Social Networks',
						'name' => 'social_networks',
						'type' => 'repeater',
						'instructions' => 'Add social networks to your team memebers',
						'column_width' => 50,
						'sub_fields' => array (
							array (
								'key' => 'field_52370d2695e34',
								'label' => 'Network',
								'name' => 'network',
								'type' => 'select',
								'instructions' => 'Choose a network',
								'column_width' => '',
								'choices' => array (
									'icon-facebook' => 'Facebook',
									'icon-twitter' => 'Twitter',
									'icon-pinterest' => 'Pinterest',
									'icon-tumblr' => 'Tumblr',
									'icon-flickr' => 'Flickr',
									'icon-google-plus' => 'Google+',
									'icon-linkedin' => 'LinkedIn',
									'icon-dribbble' => 'Dribbble',
									'icon-youtube' => 'Youtube',
								),
								'default_value' => '',
								'allow_null' => 0,
								'multiple' => 0,
							),
							array (
								'key' => 'field_52370d4f95e35',
								'label' => 'Url',
								'name' => 'url',
								'type' => 'text',
								'instructions' => 'Add the network URL',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'html',
								'maxlength' => '',
							),
						),
						'row_min' => 0,
						'row_limit' => '',
						'layout' => 'table',
						'button_label' => 'Add Row',
					),
				),
				'row_min' => 0,
				'row_limit' => '',
				'layout' => 'table',
				'button_label' => 'Add Row',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'template-about.php',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_blog-fields',
		'title' => 'Blog Fields',
		'fields' => array (
			array (
				'key' => 'field_5272487fc0822',
				'label' => 'Blog Fields',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_5272488cc0823',
				'label' => 'Page Title',
				'name' => 'page_title',
				'type' => 'text',
				'instructions' => 'Add the page title. Note: if this field is empty the Menu Title will be displayed',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_527248a3c0824',
				'label' => 'Post on page',
				'name' => 'post_on_page',
				'type' => 'number',
				'instructions' => 'Display Posts on page load. Note: negative numbers will display 3 blog posts',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'min' => '',
				'max' => '',
				'step' => '',
			),
			array (
				'key' => 'field_527248c6c0825',
				'label' => 'Disable Sidebar',
				'name' => 'disable_sidebar',
				'type' => 'true_false',
				'instructions' => 'If checked, it disables sidebar for this page',
				'message' => '',
				'default_value' => 0,
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'template-blog.php',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_blog-post-fields',
		'title' => 'Blog Post Fields',
		'fields' => array (
			array (
				'key' => 'field_52690a6a8f504',
				'label' => 'Post Type',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_52690a778f505',
				'label' => 'Type',
				'name' => 'type',
				'type' => 'radio',
				'instructions' => 'Choose one of the blog type default is none.',
				'choices' => array (
					'none' => 'None',
					'video' => 'Video',
					'slider' => 'Slider',
				),
				'other_choice' => 0,
				'save_other_choice' => 0,
				'default_value' => '',
				'layout' => 'horizontal',
			),
			array (
				'key' => 'field_52690b7cd355e',
				'label' => 'Video Host',
				'name' => 'video_host',
				'type' => 'radio',
				'instructions' => 'Choose your video source.',
				'choices' => array (
					'youtube' => 'Youtube',
					'vimeo' => 'Vimeo',
					'selfhosted' => 'Self Hosted',
				),
				'other_choice' => 0,
				'save_other_choice' => 0,
				'default_value' => '',
				'layout' => 'horizontal',
			),
			array (
				'key' => 'field_52690bf2ce9a9',
				'label' => 'Video ID',
				'name' => 'video_id',
				'type' => 'text',
				'instructions' => 'Put video your video id here.
	Ex.:
	Youtube: TBXv37PFcAQ
	Vimeo: 877053',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_52690c6ace9aa',
				'label' => 'Video File',
				'name' => 'video_file',
				'type' => 'file',
				'instructions' => 'Click here to upload video file.',
				'save_format' => 'id',
				'library' => 'all',
			),
			array (
				'key' => 'field_52690c9fce9ab',
				'label' => 'Slider',
				'name' => 'slider',
				'type' => 'repeater',
				'instructions' => 'Add slider images',
				'sub_fields' => array (
					array (
						'key' => 'field_52690ce1ce9ac',
						'label' => 'Image',
						'name' => 'image',
						'type' => 'image',
						'instructions' => 'Add Image',
						'column_width' => '',
						'save_format' => 'id',
						'preview_size' => 'home2-featured',
						'library' => 'all',
					),
				),
				'row_min' => 0,
				'row_limit' => '',
				'layout' => 'table',
				'button_label' => 'Add Row',
			),
			array (
				'key' => 'field_526facd8b1c22',
				'label' => 'Post Options',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_526facf5b1c23',
				'label' => 'Live Demo',
				'name' => 'live_demo',
				'type' => 'text',
				'instructions' => 'Add live demo link here',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'post',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_branding',
		'title' => 'Branding',
		'fields' => array (
			array (
				'key' => 'field_526a5994dda79',
				'label' => 'Background',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_526a59c3dda7a',
				'label' => 'Background Image',
				'name' => 'background_image',
				'type' => 'image',
				'instructions' => 'Add a background image',
				'save_format' => 'url',
				'preview_size' => 'large',
				'library' => 'all',
			),
			array (
				'key' => 'field_526a5a9ac83cc',
				'label' => 'Background Color',
				'name' => 'background_color',
				'type' => 'color_picker',
				'instructions' => 'Choose your background color',
				'default_value' => '',
			),
			array (
				'key' => 'field_52722d33b60b5',
				'label' => 'Theme Skins',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_52722d3eb60b6',
				'label' => 'Choose Skin',
				'name' => 'choose_skin',
				'type' => 'radio',
				'instructions' => 'Choose your theme skin ',
				'choices' => array (
					'default' => 'Default',
					'black' => 'Black',
					'blue' => 'Blue',
					'bw' => 'Black & White',
					'green' => 'Green',
					'nemo' => 'Green 2',
					'orange' => 'Orange',
					'yellow' => 'Yellow',
				),
				'other_choice' => 0,
				'save_other_choice' => 0,
				'default_value' => '',
				'layout' => 'horizontal',
			),
			array (
				'key' => 'field_527a464163c00',
				'label' => 'Advertising',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_529e1d6dd0ab7',
				'label' => 'Ads Container',
				'name' => 'ads_container',
				'type' => 'repeater',
				'instructions' => 'Add \'ADS\' by clicking Ads',
				'sub_fields' => array (
					array (
						'key' => 'field_529e1da7d0ab8',
						'label' => 'Unique Name',
						'name' => 'unique_name',
						'type' => 'text',
						'instructions' => '<b>Name must be unique</b>',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => '',
					),
					array (
						'key' => 'field_529e1dc2d0ab9',
						'label' => 'Ads',
						'name' => 'ads',
						'type' => 'repeater',
						'column_width' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_529e1de5d0aba',
								'label' => 'Image',
								'name' => 'image',
								'type' => 'image',
								'column_width' => '',
								'save_format' => 'id',
								'preview_size' => 'adv',
								'library' => 'all',
							),
							array (
								'key' => 'field_529e1df6d0abb',
								'label' => 'Url',
								'name' => 'url',
								'type' => 'text',
								'instructions' => 'Use http:// for Url',
								'column_width' => '',
								'default_value' => 'http://',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'html',
								'maxlength' => '',
							),
						),
						'row_min' => 0,
						'row_limit' => 2,
						'layout' => 'row',
						'button_label' => 'Add Row',
					),
				),
				'row_min' => 0,
				'row_limit' => '',
				'layout' => 'row',
				'button_label' => 'Ads',
			),
			array (
				'key' => 'field_527ca2e4992e1',
				'label' => 'Contact Us',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_527ca69accaa4',
				'label' => 'Info',
				'name' => '',
				'type' => 'message',
				'message' => 'These contact info will be shown on Contact Us widget',
			),
			array (
				'key' => 'field_527ca3c0992e4',
				'label' => 'Address Icon',
				'name' => 'address_icon',
				'type' => 'select',
				'instructions' => 'Choose Icon from font awsome',
				'choices' => array (
					'none' => 'none',
'icon-glass' => '&#xf000;',
'icon-music' => '&#xf001;',
'icon-search' => '&#xf002;',
'icon-envelope-alt' => '&#xf003;',
'icon-heart' => '&#xf004;',
'icon-star' => '&#xf005;',
'icon-star-empty' => '&#xf006;',
'icon-user"' => '&#xf007;',
'icon-film' => '&#xf008;',
'icon-th-large' => '&#xf009;',
'icon-th' => '&#xf00a;',
'icon-th-list' => '&#xf00b;',
'icon-ok' => '&#xf00c;',
'icon-remove' => '&#xf00d;',
'icon-zoom-in' => '&#xf00e;',
'icon-zoom-out' => '&#xf010;',
'icon-off' => '&#xf011;',
'icon-signal' => '&#xf012;',
'icon-cog' => '&#xf013;',
'icon-trash' => '&#xf014;',
'icon-home' => '&#xf015;',
'icon-file-alt' => '&#xf016;',
'icon-time' => '&#xf017;',
'icon-road' => '&#xf018;',
'icon-download-alt' => '&#xf019;',
'icon-download' => '&#xf01a;',
'icon-upload' => '&#xf01b;',
'icon-inbox' => '&#xf01c;',
'icon-play-circle' => '&#xf01d;',
'icon-repeat' => '&#xf01e;',
'icon-refresh' => '&#xf021;',
'icon-list-alt' => '&#xf022;',
'icon-lock' => '&#xf023;',
'icon-flag' => '&#xf024;',
'icon-headphones' => '&#xf025;',
'icon-volume-off' => '&#xf026;',
'icon-volume-down' => '&#xf027;',
'icon-volume-up' => '&#xf028;',
'icon-qrcode' => '&#xf029;',
'icon-barcode' => '&#xf02a;',
'icon-tag' => '&#xf02b;',
'icon-tags' => '&#xf02c;',
'icon-book' => '&#xf02d;',
'icon-bookmark' => '&#xf02e;',
'icon-print' => '&#xf02f;',
'icon-camera' => '&#xf030;',
'icon-font' => '&#xf031;',
'icon-bold' => '&#xf032;',
'icon-italic' => '&#xf033;',
'icon-text-height' => '&#xf034;',
'icon-text-width' => '&#xf035;',
'icon-align-left' => '&#xf036;',
'icon-align-center' => '&#xf037;',
'icon-align-right' => '&#xf038;',
'icon-align-justify' => '&#xf039;',
'icon-list' => '&#xf03a;',
'icon-indent-left' => '&#xf03b;',
'icon-indent-right' => '&#xf03c;',
'icon-facetime-video' => '&#xf03d;',
'icon-picture' => '&#xf03e;',
'icon-pencil' => '&#xf040;',
'icon-map-marker' => '&#xf041;',
'icon-adjust' => '&#xf042;',
'icon-tint' => '&#xf043;',
'icon-edit' => '&#xf044;',
'icon-share' => '&#xf045;',
'icon-check' => '&#xf046;',
'icon-move' => '&#xf047;',
'icon-step-backward' => '&#xf048;',
'icon-fast-backward' => '&#xf049;',
'icon-backward' => '&#xf04a;',
'icon-play' => '&#xf04b;',
'icon-pause' => '&#xf04c;',
'icon-stop' => '&#xf04d;',
'icon-forward' => '&#xf04e;',
'icon-fast-forward' => '&#xf050;',
'icon-step-forward' => '&#xf051;',
'icon-eject' => '&#xf052;',
'icon-chevron-left' => '&#xf053;',
'icon-chevron-right' => '&#xf054;',
'icon-plus-sign' => '&#xf055;',
'icon-minus-sign' => '&#xf056;',
'icon-remove-sign' => '&#xf057;',
'icon-ok-sign' => '&#xf058;',
'icon-question-sign' => '&#xf059;',
'icon-info-sign' => '&#xf05a;',
'icon-screenshot' => '&#xf05b;',
'icon-remove-circle' => '&#xf05c;',
'icon-ok-circle' => '&#xf05d;',
'icon-ban-circle' => '&#xf05e;',
'icon-arrow-left' => '&#xf060;',
'icon-arrow-right' => '&#xf061;',
'icon-arrow-up' => '&#xf062;',
'icon-arrow-down' => '&#xf063;',
'icon-share-alt' => '&#xf064;',
'icon-resize-full' => '&#xf065;',
'icon-resize-small' => '&#xf066;',
'icon-plus' => '&#xf067;',
'icon-minus' => '&#xf068;',
'icon-asterisk' => '&#xf069;',
'icon-exclamation-sign' => '&#xf06a;',
'icon-gift' => '&#xf06b;',
'icon-leaf' => '&#xf06c;',
'icon-fire' => '&#xf06d;',
'icon-eye-open' => '&#xf06e;',
'icon-eye-close' => '&#xf070;',
'icon-warning-sign' => '&#xf071;',
'icon-plane' => '&#xf072;',
'icon-calendar' => '&#xf073;',
'icon-random' => '&#xf074;',
'icon-comment' => '&#xf075;',
'icon-magnet' => '&#xf076;',
'icon-chevron-up' => '&#xf077;',
'icon-chevron-down' => '&#xf078;',
'icon-retweet' => '&#xf079;',
'icon-shopping-cart' => '&#xf07a;',
'icon-folder-close' => '&#xf07b;',
'icon-folder-open' => '&#xf07c;',
'icon-resize-vertical' => '&#xf07d;',
'icon-resize-horizontal' => '&#xf07e;',
'icon-bar-chart' => '&#xf080;',
'icon-twitter-sign' => '&#xf081;',
'icon-facebook-sign' => '&#xf082;',
'icon-camera-retro' => '&#xf083;',
'icon-key' => '&#xf084;',
'icon-cogs' => '&#xf085;',
'icon-comments' => '&#xf086;',
'icon-thumbs-up-alt' => '&#xf087;',
'icon-thumbs-down-alt' => '&#xf088;',
'icon-star-half' => '&#xf089;',
'icon-heart-empty' => '&#xf08a;',
'icon-signout' => '&#xf08b;',
'icon-linkedin-sign' => '&#xf08c;',
'icon-pushpin' => '&#xf08d;',
'icon-external-link' => '&#xf08e;',
'icon-signin' => '&#xf090;',
'icon-trophy' => '&#xf091;',
'icon-github-sign' => '&#xf092;',
'icon-upload-alt' => '&#xf093;',
'icon-lemon' => '&#xf094;',
'icon-phone' => '&#xf095;',
'icon-check-empty' => '&#xf096;',
'icon-bookmark-empty' => '&#xf097;',
'icon-phone-sign' => '&#xf098;',
'icon-twitter' => '&#xf099;',
'icon-facebook' => '&#xf09a;',
'icon-github' => '&#xf09b;',
'icon-unlock' => '&#xf09c;',
'icon-credit-card' => '&#xf09d;',
'icon-rss' => '&#xf09e;',
'icon-hdd' => '&#xf0a0;',
'icon-bullhorn' => '&#xf0a1;',
'icon-bell' => '&#xf0a2;',
'icon-certificate' => '&#xf0a3;',
'icon-hand-right' => '&#xf0a4;',
'icon-hand-left' => '&#xf0a5;',
'icon-hand-up' => '&#xf0a6;',
'icon-hand-down' => '&#xf0a7;',
'icon-circle-arrow-left' => '&#xf0a8;',
'icon-circle-arrow-right' => '&#xf0a9;',
'icon-circle-arrow-up' => '&#xf0aa;',
'icon-circle-arrow-down' => '&#xf0ab;',
'icon-globe' => '&#xf0ac;',
'icon-wrench' => '&#xf0ad;',
'icon-tasks' => '&#xf0ae;',
'icon-filter' => '&#xf0b0;',
'icon-briefcase' => '&#xf0b1;',
'icon-fullscreen' => '&#xf0b2;',
'icon-group' => '&#xf0c0;',
'icon-link' => '&#xf0c1;',
'icon-cloud' => '&#xf0c2;',
'icon-beaker' => '&#xf0c3;',
'icon-cut' => '&#xf0c4;',
'icon-copy' => '&#xf0c5;',
'icon-paper-clip' => '&#xf0c6;',
'icon-save' => '&#xf0c7;',
'icon-sign-blank' => '&#xf0c8;',
'icon-reorder' => '&#xf0c9;',
'icon-list-ul' => '&#xf0ca;',
'icon-list-ol' => '&#xf0cb;',
'icon-strikethrough' => '&#xf0cc;',
'icon-underline' => '&#xf0cd;',
'icon-table' => '&#xf0ce;',
'icon-magic' => '&#xf0d0;',
'icon-truck' => '&#xf0d1;',
'icon-pinterest' => '&#xf0d2;',
'icon-pinterest-sign' => '&#xf0d3;',
'icon-google-plus-sign' => '&#xf0d4;',
'icon-google-plus' => '&#xf0d5;',
'icon-money' => '&#xf0d6;',
'icon-caret-down' => '&#xf0d7;',
'icon-caret-up' => '&#xf0d8;',
'icon-caret-left' => '&#xf0d9;',
'icon-caret-right' => '&#xf0da;',
'icon-columns' => '&#xf0db;',
'icon-sort' => '&#xf0dc;',
'icon-sort-down' => '&#xf0dd;',
'icon-sort-up' => '&#xf0de;',
'icon-envelope' => '&#xf0e0;',
'icon-linkedin' => '&#xf0e1;',
'icon-undo' => '&#xf0e2;',
'icon-legal' => '&#xf0e3;',
'icon-dashboard' => '&#xf0e4;',
'icon-comment-alt' => '&#xf0e5;',
'icon-comments-alt' => '&#xf0e6;',
'icon-bolt' => '&#xf0e7;',
'icon-sitemap' => '&#xf0e8;',
'icon-umbrella' => '&#xf0e9;',
'icon-paste' => '&#xf0ea;',
'icon-lightbulb' => '&#xf0eb;',
'icon-exchange' => '&#xf0ec;',
'icon-cloud-download' => '&#xf0ed;',
'icon-cloud-upload' => '&#xf0ee;',
'icon-user-md' => '&#xf0f0;',
'icon-stethoscope' => '&#xf0f1;',
'icon-suitcase' => '&#xf0f2;',
'icon-bell-alt' => '&#xf0f3;',
'icon-coffee' => '&#xf0f4;',
'icon-food' => '&#xf0f5;',
'icon-file-text-alt' => '&#xf0f6;',
'icon-building' => '&#xf0f7;',
'icon-hospital' => '&#xf0f8;',
'icon-ambulance' => '&#xf0f9;',
'icon-medkit' => '&#xf0fa;',
'icon-fighter-jet' => '&#xf0fb;',
'icon-beer' => '&#xf0fc;',
'icon-h-sign' => '&#xf0fd;',
'icon-plus-sign-alt' => '&#xf0fe;',
'icon-double-angle-left' => '&#xf100;',
'icon-double-angle-right' => '&#xf101;',
'icon-double-angle-up' => '&#xf102;',
'icon-double-angle-down' => '&#xf103;',
'icon-angle-left' => '&#xf104;',
'icon-angle-right' => '&#xf105;',
'icon-angle-up' => '&#xf106;',
'icon-angle-down' => '&#xf107;',
'icon-desktop' => '&#xf108;',
'icon-laptop' => '&#xf109;',
'icon-tablet' => '&#xf10a;',
'icon-mobile-phone' => '&#xf10b;',
'icon-circle-blank' => '&#xf10c;',
'icon-quote-left' => '&#xf10d;',
'icon-quote-right' => '&#xf10e;',
'icon-spinner' => '&#xf110;',
'icon-circle' => '&#xf111;',
'icon-reply' => '&#xf112;',
'icon-github-alt' => '&#xf113;',
'icon-folder-close-alt' => '&#xf114;',
'icon-folder-open-alt' => '&#xf115;',
'icon-expand-alt' => '&#xf116;',
'icon-collapse-alt' => '&#xf117;',
'icon-smile' => '&#xf118;',
'icon-frown' => '&#xf119;',
'icon-meh' => '&#xf11a;',
'icon-gamepad' => '&#xf11b;',
'icon-keyboard' => '&#xf11c;',
'icon-flag-alt' => '&#xf11d;',
'icon-flag-checkered' => '&#xf11e;',
'icon-terminal' => '&#xf120;',
'icon-code' => '&#xf121;',
'icon-reply-all' => '&#xf122;',
'icon-mail-reply-all' => '&#xf122;',
'icon-star-half-empty' => '&#xf123;',
'icon-location-arrow' => '&#xf124;',
'icon-crop' => '&#xf125;',
'icon-code-fork' => '&#xf126;',
'icon-unlink' => '&#xf127;',
'icon-question' => '&#xf128;',
'icon-info' => '&#xf129;',
'icon-exclamation' => '&#xf12a;',
'icon-superscript' => '&#xf12b;',
'icon-subscript' => '&#xf12c;',
'icon-eraser' => '&#xf12d;',
'icon-puzzle-piece' => '&#xf12e;',
'icon-microphone' => '&#xf130;',
'icon-microphone-off' => '&#xf131;',
'icon-shield' => '&#xf132;',
'icon-calendar-empty' => '&#xf133;',
'icon-fire-extinguisher' => '&#xf134;',
'icon-rocket' => '&#xf135;',
'icon-maxcdn' => '&#xf136;',
'icon-chevron-sign-left' => '&#xf137;',
'icon-chevron-sign-right' => '&#xf138;',
'icon-chevron-sign-up' => '&#xf139;',
'icon-chevron-sign-down' => '&#xf13a;',
'icon-html5' => '&#xf13b;',
'icon-css3' => '&#xf13c;',
'icon-anchor' => '&#xf13d;',
'icon-unlock-alt' => '&#xf13e;',
'icon-bullseye' => '&#xf140;',
'icon-ellipsis-horizontal' => '&#xf141;',
'icon-ellipsis-vertical' => '&#xf142;',
'icon-rss-sign' => '&#xf143;',
'icon-play-sign' => '&#xf144;',
'icon-ticket' => '&#xf145;',
'icon-minus-sign-alt' => '&#xf146;',
'icon-check-minus' => '&#xf147;',
'icon-level-up' => '&#xf148;',
'icon-level-down' => '&#xf149;',
'icon-check-sign' => '&#xf14a;',
'icon-edit-sign' => '&#xf14b;',
'icon-external-link-sign' => '&#xf14c;',
'icon-share-sign' => '&#xf14d;',
'icon-compass' => '&#xf14e;',
'icon-collapse' => '&#xf150;',
'icon-collapse-top' => '&#xf151;',
'icon-expand' => '&#xf152;',
'icon-eur' => '&#xf153;',
'icon-gbp' => '&#xf154;',
'icon-usd' => '&#xf155;',
'icon-inr' => '&#xf156;',
'icon-jpy' => '&#xf157;',
'icon-cny' => '&#xf158;',
'icon-krw' => '&#xf159;',
'icon-btc' => '&#xf15a;',
'icon-file' => '&#xf15b;',
'icon-file-text' => '&#xf15c;',
'icon-sort-by-alphabet' => '&#xf15d;',
'icon-sort-by-alphabet-alt' => '&#xf15e;',
'icon-sort-by-attributes' => '&#xf160;',
'icon-sort-by-attributes-alt' => '&#xf161;',
'icon-sort-by-order' => '&#xf162;',
'icon-sort-by-order-alt' => '&#xf163;',
'icon-thumbs-up' => '&#xf164;',
'icon-thumbs-down' => '&#xf165;',
'icon-youtube-sign' => '&#xf166;',
'icon-youtube' => '&#xf167;',
'icon-xing' => '&#xf168;',
'icon-xing-sign' => '&#xf169;',
'icon-youtube-play' => '&#xf16a;',
'icon-dropbox' => '&#xf16b;',
'icon-stackexchange' => '&#xf16c;',
'icon-instagram' => '&#xf16d;',
'icon-flickr' => '&#xf16e;',
'icon-adn' => '&#xf170;',
'icon-bitbucket' => '&#xf171;',
'icon-bitbucket-sign' => '&#xf172;',
'icon-tumblr' => '&#xf173;',
'icon-tumblr-sign' => '&#xf174;',
'icon-long-arrow-down' => '&#xf175;',
'icon-long-arrow-up' => '&#xf176;',
'icon-long-arrow-left' => '&#xf177;',
'icon-long-arrow-right' => '&#xf178;',
'icon-apple' => '&#xf179;',
'icon-windows' => '&#xf17a;',
'icon-android' => '&#xf17b;',
'icon-linux' => '&#xf17c;',
'icon-dribbble' => '&#xf17d;',
'icon-skype' => '&#xf17e;',
'icon-foursquare' => '&#xf180;',
'icon-trello' => '&#xf181;',
'icon-female' => '&#xf182;',
'icon-male' => '&#xf183;',
'icon-gittip' => '&#xf184;',
'icon-sun' => '&#xf185;',
'icon-moon' => '&#xf186;',
'icon-archive' => '&#xf187;',
'icon-bug' => '&#xf188;',
'icon-vk' => '&#xf189;',
'icon-weibo' => '&#xf18a;',
'icon-renren' => '&#xf18b;',
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_527ca302992e2',
				'label' => 'Address Title',
				'name' => 'address_title',
				'type' => 'text',
				'instructions' => 'Add Address title',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_527ca35b992e3',
				'label' => 'Address Description',
				'name' => 'address_description',
				'type' => 'textarea',
				'instructions' => 'Add your specific address description',
				'default_value' => '',
				'placeholder' => '',
				'maxlength' => '',
				'formatting' => 'br',
			),
			array (
				'key' => 'field_527ca47f68996',
				'label' => 'Phone Icon',
				'name' => 'phone_icon',
				'type' => 'select',
				'instructions' => 'Choose Icon from font awsome',
				'choices' => array (
					'none' => 'none',
'icon-glass' => '&#xf000;',
'icon-music' => '&#xf001;',
'icon-search' => '&#xf002;',
'icon-envelope-alt' => '&#xf003;',
'icon-heart' => '&#xf004;',
'icon-star' => '&#xf005;',
'icon-star-empty' => '&#xf006;',
'icon-user"' => '&#xf007;',
'icon-film' => '&#xf008;',
'icon-th-large' => '&#xf009;',
'icon-th' => '&#xf00a;',
'icon-th-list' => '&#xf00b;',
'icon-ok' => '&#xf00c;',
'icon-remove' => '&#xf00d;',
'icon-zoom-in' => '&#xf00e;',
'icon-zoom-out' => '&#xf010;',
'icon-off' => '&#xf011;',
'icon-signal' => '&#xf012;',
'icon-cog' => '&#xf013;',
'icon-trash' => '&#xf014;',
'icon-home' => '&#xf015;',
'icon-file-alt' => '&#xf016;',
'icon-time' => '&#xf017;',
'icon-road' => '&#xf018;',
'icon-download-alt' => '&#xf019;',
'icon-download' => '&#xf01a;',
'icon-upload' => '&#xf01b;',
'icon-inbox' => '&#xf01c;',
'icon-play-circle' => '&#xf01d;',
'icon-repeat' => '&#xf01e;',
'icon-refresh' => '&#xf021;',
'icon-list-alt' => '&#xf022;',
'icon-lock' => '&#xf023;',
'icon-flag' => '&#xf024;',
'icon-headphones' => '&#xf025;',
'icon-volume-off' => '&#xf026;',
'icon-volume-down' => '&#xf027;',
'icon-volume-up' => '&#xf028;',
'icon-qrcode' => '&#xf029;',
'icon-barcode' => '&#xf02a;',
'icon-tag' => '&#xf02b;',
'icon-tags' => '&#xf02c;',
'icon-book' => '&#xf02d;',
'icon-bookmark' => '&#xf02e;',
'icon-print' => '&#xf02f;',
'icon-camera' => '&#xf030;',
'icon-font' => '&#xf031;',
'icon-bold' => '&#xf032;',
'icon-italic' => '&#xf033;',
'icon-text-height' => '&#xf034;',
'icon-text-width' => '&#xf035;',
'icon-align-left' => '&#xf036;',
'icon-align-center' => '&#xf037;',
'icon-align-right' => '&#xf038;',
'icon-align-justify' => '&#xf039;',
'icon-list' => '&#xf03a;',
'icon-indent-left' => '&#xf03b;',
'icon-indent-right' => '&#xf03c;',
'icon-facetime-video' => '&#xf03d;',
'icon-picture' => '&#xf03e;',
'icon-pencil' => '&#xf040;',
'icon-map-marker' => '&#xf041;',
'icon-adjust' => '&#xf042;',
'icon-tint' => '&#xf043;',
'icon-edit' => '&#xf044;',
'icon-share' => '&#xf045;',
'icon-check' => '&#xf046;',
'icon-move' => '&#xf047;',
'icon-step-backward' => '&#xf048;',
'icon-fast-backward' => '&#xf049;',
'icon-backward' => '&#xf04a;',
'icon-play' => '&#xf04b;',
'icon-pause' => '&#xf04c;',
'icon-stop' => '&#xf04d;',
'icon-forward' => '&#xf04e;',
'icon-fast-forward' => '&#xf050;',
'icon-step-forward' => '&#xf051;',
'icon-eject' => '&#xf052;',
'icon-chevron-left' => '&#xf053;',
'icon-chevron-right' => '&#xf054;',
'icon-plus-sign' => '&#xf055;',
'icon-minus-sign' => '&#xf056;',
'icon-remove-sign' => '&#xf057;',
'icon-ok-sign' => '&#xf058;',
'icon-question-sign' => '&#xf059;',
'icon-info-sign' => '&#xf05a;',
'icon-screenshot' => '&#xf05b;',
'icon-remove-circle' => '&#xf05c;',
'icon-ok-circle' => '&#xf05d;',
'icon-ban-circle' => '&#xf05e;',
'icon-arrow-left' => '&#xf060;',
'icon-arrow-right' => '&#xf061;',
'icon-arrow-up' => '&#xf062;',
'icon-arrow-down' => '&#xf063;',
'icon-share-alt' => '&#xf064;',
'icon-resize-full' => '&#xf065;',
'icon-resize-small' => '&#xf066;',
'icon-plus' => '&#xf067;',
'icon-minus' => '&#xf068;',
'icon-asterisk' => '&#xf069;',
'icon-exclamation-sign' => '&#xf06a;',
'icon-gift' => '&#xf06b;',
'icon-leaf' => '&#xf06c;',
'icon-fire' => '&#xf06d;',
'icon-eye-open' => '&#xf06e;',
'icon-eye-close' => '&#xf070;',
'icon-warning-sign' => '&#xf071;',
'icon-plane' => '&#xf072;',
'icon-calendar' => '&#xf073;',
'icon-random' => '&#xf074;',
'icon-comment' => '&#xf075;',
'icon-magnet' => '&#xf076;',
'icon-chevron-up' => '&#xf077;',
'icon-chevron-down' => '&#xf078;',
'icon-retweet' => '&#xf079;',
'icon-shopping-cart' => '&#xf07a;',
'icon-folder-close' => '&#xf07b;',
'icon-folder-open' => '&#xf07c;',
'icon-resize-vertical' => '&#xf07d;',
'icon-resize-horizontal' => '&#xf07e;',
'icon-bar-chart' => '&#xf080;',
'icon-twitter-sign' => '&#xf081;',
'icon-facebook-sign' => '&#xf082;',
'icon-camera-retro' => '&#xf083;',
'icon-key' => '&#xf084;',
'icon-cogs' => '&#xf085;',
'icon-comments' => '&#xf086;',
'icon-thumbs-up-alt' => '&#xf087;',
'icon-thumbs-down-alt' => '&#xf088;',
'icon-star-half' => '&#xf089;',
'icon-heart-empty' => '&#xf08a;',
'icon-signout' => '&#xf08b;',
'icon-linkedin-sign' => '&#xf08c;',
'icon-pushpin' => '&#xf08d;',
'icon-external-link' => '&#xf08e;',
'icon-signin' => '&#xf090;',
'icon-trophy' => '&#xf091;',
'icon-github-sign' => '&#xf092;',
'icon-upload-alt' => '&#xf093;',
'icon-lemon' => '&#xf094;',
'icon-phone' => '&#xf095;',
'icon-check-empty' => '&#xf096;',
'icon-bookmark-empty' => '&#xf097;',
'icon-phone-sign' => '&#xf098;',
'icon-twitter' => '&#xf099;',
'icon-facebook' => '&#xf09a;',
'icon-github' => '&#xf09b;',
'icon-unlock' => '&#xf09c;',
'icon-credit-card' => '&#xf09d;',
'icon-rss' => '&#xf09e;',
'icon-hdd' => '&#xf0a0;',
'icon-bullhorn' => '&#xf0a1;',
'icon-bell' => '&#xf0a2;',
'icon-certificate' => '&#xf0a3;',
'icon-hand-right' => '&#xf0a4;',
'icon-hand-left' => '&#xf0a5;',
'icon-hand-up' => '&#xf0a6;',
'icon-hand-down' => '&#xf0a7;',
'icon-circle-arrow-left' => '&#xf0a8;',
'icon-circle-arrow-right' => '&#xf0a9;',
'icon-circle-arrow-up' => '&#xf0aa;',
'icon-circle-arrow-down' => '&#xf0ab;',
'icon-globe' => '&#xf0ac;',
'icon-wrench' => '&#xf0ad;',
'icon-tasks' => '&#xf0ae;',
'icon-filter' => '&#xf0b0;',
'icon-briefcase' => '&#xf0b1;',
'icon-fullscreen' => '&#xf0b2;',
'icon-group' => '&#xf0c0;',
'icon-link' => '&#xf0c1;',
'icon-cloud' => '&#xf0c2;',
'icon-beaker' => '&#xf0c3;',
'icon-cut' => '&#xf0c4;',
'icon-copy' => '&#xf0c5;',
'icon-paper-clip' => '&#xf0c6;',
'icon-save' => '&#xf0c7;',
'icon-sign-blank' => '&#xf0c8;',
'icon-reorder' => '&#xf0c9;',
'icon-list-ul' => '&#xf0ca;',
'icon-list-ol' => '&#xf0cb;',
'icon-strikethrough' => '&#xf0cc;',
'icon-underline' => '&#xf0cd;',
'icon-table' => '&#xf0ce;',
'icon-magic' => '&#xf0d0;',
'icon-truck' => '&#xf0d1;',
'icon-pinterest' => '&#xf0d2;',
'icon-pinterest-sign' => '&#xf0d3;',
'icon-google-plus-sign' => '&#xf0d4;',
'icon-google-plus' => '&#xf0d5;',
'icon-money' => '&#xf0d6;',
'icon-caret-down' => '&#xf0d7;',
'icon-caret-up' => '&#xf0d8;',
'icon-caret-left' => '&#xf0d9;',
'icon-caret-right' => '&#xf0da;',
'icon-columns' => '&#xf0db;',
'icon-sort' => '&#xf0dc;',
'icon-sort-down' => '&#xf0dd;',
'icon-sort-up' => '&#xf0de;',
'icon-envelope' => '&#xf0e0;',
'icon-linkedin' => '&#xf0e1;',
'icon-undo' => '&#xf0e2;',
'icon-legal' => '&#xf0e3;',
'icon-dashboard' => '&#xf0e4;',
'icon-comment-alt' => '&#xf0e5;',
'icon-comments-alt' => '&#xf0e6;',
'icon-bolt' => '&#xf0e7;',
'icon-sitemap' => '&#xf0e8;',
'icon-umbrella' => '&#xf0e9;',
'icon-paste' => '&#xf0ea;',
'icon-lightbulb' => '&#xf0eb;',
'icon-exchange' => '&#xf0ec;',
'icon-cloud-download' => '&#xf0ed;',
'icon-cloud-upload' => '&#xf0ee;',
'icon-user-md' => '&#xf0f0;',
'icon-stethoscope' => '&#xf0f1;',
'icon-suitcase' => '&#xf0f2;',
'icon-bell-alt' => '&#xf0f3;',
'icon-coffee' => '&#xf0f4;',
'icon-food' => '&#xf0f5;',
'icon-file-text-alt' => '&#xf0f6;',
'icon-building' => '&#xf0f7;',
'icon-hospital' => '&#xf0f8;',
'icon-ambulance' => '&#xf0f9;',
'icon-medkit' => '&#xf0fa;',
'icon-fighter-jet' => '&#xf0fb;',
'icon-beer' => '&#xf0fc;',
'icon-h-sign' => '&#xf0fd;',
'icon-plus-sign-alt' => '&#xf0fe;',
'icon-double-angle-left' => '&#xf100;',
'icon-double-angle-right' => '&#xf101;',
'icon-double-angle-up' => '&#xf102;',
'icon-double-angle-down' => '&#xf103;',
'icon-angle-left' => '&#xf104;',
'icon-angle-right' => '&#xf105;',
'icon-angle-up' => '&#xf106;',
'icon-angle-down' => '&#xf107;',
'icon-desktop' => '&#xf108;',
'icon-laptop' => '&#xf109;',
'icon-tablet' => '&#xf10a;',
'icon-mobile-phone' => '&#xf10b;',
'icon-circle-blank' => '&#xf10c;',
'icon-quote-left' => '&#xf10d;',
'icon-quote-right' => '&#xf10e;',
'icon-spinner' => '&#xf110;',
'icon-circle' => '&#xf111;',
'icon-reply' => '&#xf112;',
'icon-github-alt' => '&#xf113;',
'icon-folder-close-alt' => '&#xf114;',
'icon-folder-open-alt' => '&#xf115;',
'icon-expand-alt' => '&#xf116;',
'icon-collapse-alt' => '&#xf117;',
'icon-smile' => '&#xf118;',
'icon-frown' => '&#xf119;',
'icon-meh' => '&#xf11a;',
'icon-gamepad' => '&#xf11b;',
'icon-keyboard' => '&#xf11c;',
'icon-flag-alt' => '&#xf11d;',
'icon-flag-checkered' => '&#xf11e;',
'icon-terminal' => '&#xf120;',
'icon-code' => '&#xf121;',
'icon-reply-all' => '&#xf122;',
'icon-mail-reply-all' => '&#xf122;',
'icon-star-half-empty' => '&#xf123;',
'icon-location-arrow' => '&#xf124;',
'icon-crop' => '&#xf125;',
'icon-code-fork' => '&#xf126;',
'icon-unlink' => '&#xf127;',
'icon-question' => '&#xf128;',
'icon-info' => '&#xf129;',
'icon-exclamation' => '&#xf12a;',
'icon-superscript' => '&#xf12b;',
'icon-subscript' => '&#xf12c;',
'icon-eraser' => '&#xf12d;',
'icon-puzzle-piece' => '&#xf12e;',
'icon-microphone' => '&#xf130;',
'icon-microphone-off' => '&#xf131;',
'icon-shield' => '&#xf132;',
'icon-calendar-empty' => '&#xf133;',
'icon-fire-extinguisher' => '&#xf134;',
'icon-rocket' => '&#xf135;',
'icon-maxcdn' => '&#xf136;',
'icon-chevron-sign-left' => '&#xf137;',
'icon-chevron-sign-right' => '&#xf138;',
'icon-chevron-sign-up' => '&#xf139;',
'icon-chevron-sign-down' => '&#xf13a;',
'icon-html5' => '&#xf13b;',
'icon-css3' => '&#xf13c;',
'icon-anchor' => '&#xf13d;',
'icon-unlock-alt' => '&#xf13e;',
'icon-bullseye' => '&#xf140;',
'icon-ellipsis-horizontal' => '&#xf141;',
'icon-ellipsis-vertical' => '&#xf142;',
'icon-rss-sign' => '&#xf143;',
'icon-play-sign' => '&#xf144;',
'icon-ticket' => '&#xf145;',
'icon-minus-sign-alt' => '&#xf146;',
'icon-check-minus' => '&#xf147;',
'icon-level-up' => '&#xf148;',
'icon-level-down' => '&#xf149;',
'icon-check-sign' => '&#xf14a;',
'icon-edit-sign' => '&#xf14b;',
'icon-external-link-sign' => '&#xf14c;',
'icon-share-sign' => '&#xf14d;',
'icon-compass' => '&#xf14e;',
'icon-collapse' => '&#xf150;',
'icon-collapse-top' => '&#xf151;',
'icon-expand' => '&#xf152;',
'icon-eur' => '&#xf153;',
'icon-gbp' => '&#xf154;',
'icon-usd' => '&#xf155;',
'icon-inr' => '&#xf156;',
'icon-jpy' => '&#xf157;',
'icon-cny' => '&#xf158;',
'icon-krw' => '&#xf159;',
'icon-btc' => '&#xf15a;',
'icon-file' => '&#xf15b;',
'icon-file-text' => '&#xf15c;',
'icon-sort-by-alphabet' => '&#xf15d;',
'icon-sort-by-alphabet-alt' => '&#xf15e;',
'icon-sort-by-attributes' => '&#xf160;',
'icon-sort-by-attributes-alt' => '&#xf161;',
'icon-sort-by-order' => '&#xf162;',
'icon-sort-by-order-alt' => '&#xf163;',
'icon-thumbs-up' => '&#xf164;',
'icon-thumbs-down' => '&#xf165;',
'icon-youtube-sign' => '&#xf166;',
'icon-youtube' => '&#xf167;',
'icon-xing' => '&#xf168;',
'icon-xing-sign' => '&#xf169;',
'icon-youtube-play' => '&#xf16a;',
'icon-dropbox' => '&#xf16b;',
'icon-stackexchange' => '&#xf16c;',
'icon-instagram' => '&#xf16d;',
'icon-flickr' => '&#xf16e;',
'icon-adn' => '&#xf170;',
'icon-bitbucket' => '&#xf171;',
'icon-bitbucket-sign' => '&#xf172;',
'icon-tumblr' => '&#xf173;',
'icon-tumblr-sign' => '&#xf174;',
'icon-long-arrow-down' => '&#xf175;',
'icon-long-arrow-up' => '&#xf176;',
'icon-long-arrow-left' => '&#xf177;',
'icon-long-arrow-right' => '&#xf178;',
'icon-apple' => '&#xf179;',
'icon-windows' => '&#xf17a;',
'icon-android' => '&#xf17b;',
'icon-linux' => '&#xf17c;',
'icon-dribbble' => '&#xf17d;',
'icon-skype' => '&#xf17e;',
'icon-foursquare' => '&#xf180;',
'icon-trello' => '&#xf181;',
'icon-female' => '&#xf182;',
'icon-male' => '&#xf183;',
'icon-gittip' => '&#xf184;',
'icon-sun' => '&#xf185;',
'icon-moon' => '&#xf186;',
'icon-archive' => '&#xf187;',
'icon-bug' => '&#xf188;',
'icon-vk' => '&#xf189;',
'icon-weibo' => '&#xf18a;',
'icon-renren' => '&#xf18b;',
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_527ca45768994',
				'label' => 'Phone Title',
				'name' => 'phone_title',
				'type' => 'text',
				'instructions' => 'Add phone title',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_527ca46968995',
				'label' => 'Phone Number',
				'name' => 'phone_number',
				'type' => 'text',
				'instructions' => 'Add phone numbers',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_527ca5b7d3719',
				'label' => 'Email Icon',
				'name' => 'email_icon',
				'type' => 'select',
				'instructions' => 'Choose font awsome icon',
				'choices' => array (
					'none' => 'none',
'icon-glass' => '&#xf000;',
'icon-music' => '&#xf001;',
'icon-search' => '&#xf002;',
'icon-envelope-alt' => '&#xf003;',
'icon-heart' => '&#xf004;',
'icon-star' => '&#xf005;',
'icon-star-empty' => '&#xf006;',
'icon-user"' => '&#xf007;',
'icon-film' => '&#xf008;',
'icon-th-large' => '&#xf009;',
'icon-th' => '&#xf00a;',
'icon-th-list' => '&#xf00b;',
'icon-ok' => '&#xf00c;',
'icon-remove' => '&#xf00d;',
'icon-zoom-in' => '&#xf00e;',
'icon-zoom-out' => '&#xf010;',
'icon-off' => '&#xf011;',
'icon-signal' => '&#xf012;',
'icon-cog' => '&#xf013;',
'icon-trash' => '&#xf014;',
'icon-home' => '&#xf015;',
'icon-file-alt' => '&#xf016;',
'icon-time' => '&#xf017;',
'icon-road' => '&#xf018;',
'icon-download-alt' => '&#xf019;',
'icon-download' => '&#xf01a;',
'icon-upload' => '&#xf01b;',
'icon-inbox' => '&#xf01c;',
'icon-play-circle' => '&#xf01d;',
'icon-repeat' => '&#xf01e;',
'icon-refresh' => '&#xf021;',
'icon-list-alt' => '&#xf022;',
'icon-lock' => '&#xf023;',
'icon-flag' => '&#xf024;',
'icon-headphones' => '&#xf025;',
'icon-volume-off' => '&#xf026;',
'icon-volume-down' => '&#xf027;',
'icon-volume-up' => '&#xf028;',
'icon-qrcode' => '&#xf029;',
'icon-barcode' => '&#xf02a;',
'icon-tag' => '&#xf02b;',
'icon-tags' => '&#xf02c;',
'icon-book' => '&#xf02d;',
'icon-bookmark' => '&#xf02e;',
'icon-print' => '&#xf02f;',
'icon-camera' => '&#xf030;',
'icon-font' => '&#xf031;',
'icon-bold' => '&#xf032;',
'icon-italic' => '&#xf033;',
'icon-text-height' => '&#xf034;',
'icon-text-width' => '&#xf035;',
'icon-align-left' => '&#xf036;',
'icon-align-center' => '&#xf037;',
'icon-align-right' => '&#xf038;',
'icon-align-justify' => '&#xf039;',
'icon-list' => '&#xf03a;',
'icon-indent-left' => '&#xf03b;',
'icon-indent-right' => '&#xf03c;',
'icon-facetime-video' => '&#xf03d;',
'icon-picture' => '&#xf03e;',
'icon-pencil' => '&#xf040;',
'icon-map-marker' => '&#xf041;',
'icon-adjust' => '&#xf042;',
'icon-tint' => '&#xf043;',
'icon-edit' => '&#xf044;',
'icon-share' => '&#xf045;',
'icon-check' => '&#xf046;',
'icon-move' => '&#xf047;',
'icon-step-backward' => '&#xf048;',
'icon-fast-backward' => '&#xf049;',
'icon-backward' => '&#xf04a;',
'icon-play' => '&#xf04b;',
'icon-pause' => '&#xf04c;',
'icon-stop' => '&#xf04d;',
'icon-forward' => '&#xf04e;',
'icon-fast-forward' => '&#xf050;',
'icon-step-forward' => '&#xf051;',
'icon-eject' => '&#xf052;',
'icon-chevron-left' => '&#xf053;',
'icon-chevron-right' => '&#xf054;',
'icon-plus-sign' => '&#xf055;',
'icon-minus-sign' => '&#xf056;',
'icon-remove-sign' => '&#xf057;',
'icon-ok-sign' => '&#xf058;',
'icon-question-sign' => '&#xf059;',
'icon-info-sign' => '&#xf05a;',
'icon-screenshot' => '&#xf05b;',
'icon-remove-circle' => '&#xf05c;',
'icon-ok-circle' => '&#xf05d;',
'icon-ban-circle' => '&#xf05e;',
'icon-arrow-left' => '&#xf060;',
'icon-arrow-right' => '&#xf061;',
'icon-arrow-up' => '&#xf062;',
'icon-arrow-down' => '&#xf063;',
'icon-share-alt' => '&#xf064;',
'icon-resize-full' => '&#xf065;',
'icon-resize-small' => '&#xf066;',
'icon-plus' => '&#xf067;',
'icon-minus' => '&#xf068;',
'icon-asterisk' => '&#xf069;',
'icon-exclamation-sign' => '&#xf06a;',
'icon-gift' => '&#xf06b;',
'icon-leaf' => '&#xf06c;',
'icon-fire' => '&#xf06d;',
'icon-eye-open' => '&#xf06e;',
'icon-eye-close' => '&#xf070;',
'icon-warning-sign' => '&#xf071;',
'icon-plane' => '&#xf072;',
'icon-calendar' => '&#xf073;',
'icon-random' => '&#xf074;',
'icon-comment' => '&#xf075;',
'icon-magnet' => '&#xf076;',
'icon-chevron-up' => '&#xf077;',
'icon-chevron-down' => '&#xf078;',
'icon-retweet' => '&#xf079;',
'icon-shopping-cart' => '&#xf07a;',
'icon-folder-close' => '&#xf07b;',
'icon-folder-open' => '&#xf07c;',
'icon-resize-vertical' => '&#xf07d;',
'icon-resize-horizontal' => '&#xf07e;',
'icon-bar-chart' => '&#xf080;',
'icon-twitter-sign' => '&#xf081;',
'icon-facebook-sign' => '&#xf082;',
'icon-camera-retro' => '&#xf083;',
'icon-key' => '&#xf084;',
'icon-cogs' => '&#xf085;',
'icon-comments' => '&#xf086;',
'icon-thumbs-up-alt' => '&#xf087;',
'icon-thumbs-down-alt' => '&#xf088;',
'icon-star-half' => '&#xf089;',
'icon-heart-empty' => '&#xf08a;',
'icon-signout' => '&#xf08b;',
'icon-linkedin-sign' => '&#xf08c;',
'icon-pushpin' => '&#xf08d;',
'icon-external-link' => '&#xf08e;',
'icon-signin' => '&#xf090;',
'icon-trophy' => '&#xf091;',
'icon-github-sign' => '&#xf092;',
'icon-upload-alt' => '&#xf093;',
'icon-lemon' => '&#xf094;',
'icon-phone' => '&#xf095;',
'icon-check-empty' => '&#xf096;',
'icon-bookmark-empty' => '&#xf097;',
'icon-phone-sign' => '&#xf098;',
'icon-twitter' => '&#xf099;',
'icon-facebook' => '&#xf09a;',
'icon-github' => '&#xf09b;',
'icon-unlock' => '&#xf09c;',
'icon-credit-card' => '&#xf09d;',
'icon-rss' => '&#xf09e;',
'icon-hdd' => '&#xf0a0;',
'icon-bullhorn' => '&#xf0a1;',
'icon-bell' => '&#xf0a2;',
'icon-certificate' => '&#xf0a3;',
'icon-hand-right' => '&#xf0a4;',
'icon-hand-left' => '&#xf0a5;',
'icon-hand-up' => '&#xf0a6;',
'icon-hand-down' => '&#xf0a7;',
'icon-circle-arrow-left' => '&#xf0a8;',
'icon-circle-arrow-right' => '&#xf0a9;',
'icon-circle-arrow-up' => '&#xf0aa;',
'icon-circle-arrow-down' => '&#xf0ab;',
'icon-globe' => '&#xf0ac;',
'icon-wrench' => '&#xf0ad;',
'icon-tasks' => '&#xf0ae;',
'icon-filter' => '&#xf0b0;',
'icon-briefcase' => '&#xf0b1;',
'icon-fullscreen' => '&#xf0b2;',
'icon-group' => '&#xf0c0;',
'icon-link' => '&#xf0c1;',
'icon-cloud' => '&#xf0c2;',
'icon-beaker' => '&#xf0c3;',
'icon-cut' => '&#xf0c4;',
'icon-copy' => '&#xf0c5;',
'icon-paper-clip' => '&#xf0c6;',
'icon-save' => '&#xf0c7;',
'icon-sign-blank' => '&#xf0c8;',
'icon-reorder' => '&#xf0c9;',
'icon-list-ul' => '&#xf0ca;',
'icon-list-ol' => '&#xf0cb;',
'icon-strikethrough' => '&#xf0cc;',
'icon-underline' => '&#xf0cd;',
'icon-table' => '&#xf0ce;',
'icon-magic' => '&#xf0d0;',
'icon-truck' => '&#xf0d1;',
'icon-pinterest' => '&#xf0d2;',
'icon-pinterest-sign' => '&#xf0d3;',
'icon-google-plus-sign' => '&#xf0d4;',
'icon-google-plus' => '&#xf0d5;',
'icon-money' => '&#xf0d6;',
'icon-caret-down' => '&#xf0d7;',
'icon-caret-up' => '&#xf0d8;',
'icon-caret-left' => '&#xf0d9;',
'icon-caret-right' => '&#xf0da;',
'icon-columns' => '&#xf0db;',
'icon-sort' => '&#xf0dc;',
'icon-sort-down' => '&#xf0dd;',
'icon-sort-up' => '&#xf0de;',
'icon-envelope' => '&#xf0e0;',
'icon-linkedin' => '&#xf0e1;',
'icon-undo' => '&#xf0e2;',
'icon-legal' => '&#xf0e3;',
'icon-dashboard' => '&#xf0e4;',
'icon-comment-alt' => '&#xf0e5;',
'icon-comments-alt' => '&#xf0e6;',
'icon-bolt' => '&#xf0e7;',
'icon-sitemap' => '&#xf0e8;',
'icon-umbrella' => '&#xf0e9;',
'icon-paste' => '&#xf0ea;',
'icon-lightbulb' => '&#xf0eb;',
'icon-exchange' => '&#xf0ec;',
'icon-cloud-download' => '&#xf0ed;',
'icon-cloud-upload' => '&#xf0ee;',
'icon-user-md' => '&#xf0f0;',
'icon-stethoscope' => '&#xf0f1;',
'icon-suitcase' => '&#xf0f2;',
'icon-bell-alt' => '&#xf0f3;',
'icon-coffee' => '&#xf0f4;',
'icon-food' => '&#xf0f5;',
'icon-file-text-alt' => '&#xf0f6;',
'icon-building' => '&#xf0f7;',
'icon-hospital' => '&#xf0f8;',
'icon-ambulance' => '&#xf0f9;',
'icon-medkit' => '&#xf0fa;',
'icon-fighter-jet' => '&#xf0fb;',
'icon-beer' => '&#xf0fc;',
'icon-h-sign' => '&#xf0fd;',
'icon-plus-sign-alt' => '&#xf0fe;',
'icon-double-angle-left' => '&#xf100;',
'icon-double-angle-right' => '&#xf101;',
'icon-double-angle-up' => '&#xf102;',
'icon-double-angle-down' => '&#xf103;',
'icon-angle-left' => '&#xf104;',
'icon-angle-right' => '&#xf105;',
'icon-angle-up' => '&#xf106;',
'icon-angle-down' => '&#xf107;',
'icon-desktop' => '&#xf108;',
'icon-laptop' => '&#xf109;',
'icon-tablet' => '&#xf10a;',
'icon-mobile-phone' => '&#xf10b;',
'icon-circle-blank' => '&#xf10c;',
'icon-quote-left' => '&#xf10d;',
'icon-quote-right' => '&#xf10e;',
'icon-spinner' => '&#xf110;',
'icon-circle' => '&#xf111;',
'icon-reply' => '&#xf112;',
'icon-github-alt' => '&#xf113;',
'icon-folder-close-alt' => '&#xf114;',
'icon-folder-open-alt' => '&#xf115;',
'icon-expand-alt' => '&#xf116;',
'icon-collapse-alt' => '&#xf117;',
'icon-smile' => '&#xf118;',
'icon-frown' => '&#xf119;',
'icon-meh' => '&#xf11a;',
'icon-gamepad' => '&#xf11b;',
'icon-keyboard' => '&#xf11c;',
'icon-flag-alt' => '&#xf11d;',
'icon-flag-checkered' => '&#xf11e;',
'icon-terminal' => '&#xf120;',
'icon-code' => '&#xf121;',
'icon-reply-all' => '&#xf122;',
'icon-mail-reply-all' => '&#xf122;',
'icon-star-half-empty' => '&#xf123;',
'icon-location-arrow' => '&#xf124;',
'icon-crop' => '&#xf125;',
'icon-code-fork' => '&#xf126;',
'icon-unlink' => '&#xf127;',
'icon-question' => '&#xf128;',
'icon-info' => '&#xf129;',
'icon-exclamation' => '&#xf12a;',
'icon-superscript' => '&#xf12b;',
'icon-subscript' => '&#xf12c;',
'icon-eraser' => '&#xf12d;',
'icon-puzzle-piece' => '&#xf12e;',
'icon-microphone' => '&#xf130;',
'icon-microphone-off' => '&#xf131;',
'icon-shield' => '&#xf132;',
'icon-calendar-empty' => '&#xf133;',
'icon-fire-extinguisher' => '&#xf134;',
'icon-rocket' => '&#xf135;',
'icon-maxcdn' => '&#xf136;',
'icon-chevron-sign-left' => '&#xf137;',
'icon-chevron-sign-right' => '&#xf138;',
'icon-chevron-sign-up' => '&#xf139;',
'icon-chevron-sign-down' => '&#xf13a;',
'icon-html5' => '&#xf13b;',
'icon-css3' => '&#xf13c;',
'icon-anchor' => '&#xf13d;',
'icon-unlock-alt' => '&#xf13e;',
'icon-bullseye' => '&#xf140;',
'icon-ellipsis-horizontal' => '&#xf141;',
'icon-ellipsis-vertical' => '&#xf142;',
'icon-rss-sign' => '&#xf143;',
'icon-play-sign' => '&#xf144;',
'icon-ticket' => '&#xf145;',
'icon-minus-sign-alt' => '&#xf146;',
'icon-check-minus' => '&#xf147;',
'icon-level-up' => '&#xf148;',
'icon-level-down' => '&#xf149;',
'icon-check-sign' => '&#xf14a;',
'icon-edit-sign' => '&#xf14b;',
'icon-external-link-sign' => '&#xf14c;',
'icon-share-sign' => '&#xf14d;',
'icon-compass' => '&#xf14e;',
'icon-collapse' => '&#xf150;',
'icon-collapse-top' => '&#xf151;',
'icon-expand' => '&#xf152;',
'icon-eur' => '&#xf153;',
'icon-gbp' => '&#xf154;',
'icon-usd' => '&#xf155;',
'icon-inr' => '&#xf156;',
'icon-jpy' => '&#xf157;',
'icon-cny' => '&#xf158;',
'icon-krw' => '&#xf159;',
'icon-btc' => '&#xf15a;',
'icon-file' => '&#xf15b;',
'icon-file-text' => '&#xf15c;',
'icon-sort-by-alphabet' => '&#xf15d;',
'icon-sort-by-alphabet-alt' => '&#xf15e;',
'icon-sort-by-attributes' => '&#xf160;',
'icon-sort-by-attributes-alt' => '&#xf161;',
'icon-sort-by-order' => '&#xf162;',
'icon-sort-by-order-alt' => '&#xf163;',
'icon-thumbs-up' => '&#xf164;',
'icon-thumbs-down' => '&#xf165;',
'icon-youtube-sign' => '&#xf166;',
'icon-youtube' => '&#xf167;',
'icon-xing' => '&#xf168;',
'icon-xing-sign' => '&#xf169;',
'icon-youtube-play' => '&#xf16a;',
'icon-dropbox' => '&#xf16b;',
'icon-stackexchange' => '&#xf16c;',
'icon-instagram' => '&#xf16d;',
'icon-flickr' => '&#xf16e;',
'icon-adn' => '&#xf170;',
'icon-bitbucket' => '&#xf171;',
'icon-bitbucket-sign' => '&#xf172;',
'icon-tumblr' => '&#xf173;',
'icon-tumblr-sign' => '&#xf174;',
'icon-long-arrow-down' => '&#xf175;',
'icon-long-arrow-up' => '&#xf176;',
'icon-long-arrow-left' => '&#xf177;',
'icon-long-arrow-right' => '&#xf178;',
'icon-apple' => '&#xf179;',
'icon-windows' => '&#xf17a;',
'icon-android' => '&#xf17b;',
'icon-linux' => '&#xf17c;',
'icon-dribbble' => '&#xf17d;',
'icon-skype' => '&#xf17e;',
'icon-foursquare' => '&#xf180;',
'icon-trello' => '&#xf181;',
'icon-female' => '&#xf182;',
'icon-male' => '&#xf183;',
'icon-gittip' => '&#xf184;',
'icon-sun' => '&#xf185;',
'icon-moon' => '&#xf186;',
'icon-archive' => '&#xf187;',
'icon-bug' => '&#xf188;',
'icon-vk' => '&#xf189;',
'icon-weibo' => '&#xf18a;',
'icon-renren' => '&#xf18b;',
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_527ca5d5d371a',
				'label' => 'Email Title',
				'name' => 'email_title',
				'type' => 'text',
				'instructions' => 'Add email title',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_527ca5e6d371b',
				'label' => 'Email Address',
				'name' => 'email_address',
				'type' => 'text',
				'instructions' => 'Add email address',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'options_page',
					'operator' => '==',
					'value' => 'acf-options-branding',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_contact-fields',
		'title' => 'Contact Fields',
		'fields' => array (
			array (
				'key' => 'field_525462eb8abec',
				'label' => 'Contact Info',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_5254520f6e71a',
				'label' => 'Contact Title',
				'name' => 'contact_title',
				'type' => 'text',
				'instructions' => 'Add the title of contact page',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_525463008abed',
				'label' => 'Address Title',
				'name' => 'address_title',
				'type' => 'text',
				'instructions' => 'Add text to display as address title',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_52546345ad9fe',
				'label' => 'Address Description',
				'name' => 'address_description',
				'type' => 'wysiwyg',
				'instructions' => 'Add address info',
				'default_value' => '',
				'toolbar' => 'full',
				'media_upload' => 'yes',
			),
			array (
				'key' => 'field_525463856395f',
				'label' => 'E-mail adress',
				'name' => 'e-mail_adress',
				'type' => 'text',
				'instructions' => 'Add e-mail title',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5254640763960',
				'label' => 'E-mails',
				'name' => 'e-mails',
				'type' => 'wysiwyg',
				'instructions' => 'Add emails',
				'default_value' => '',
				'toolbar' => 'full',
				'media_upload' => 'yes',
			),
			array (
				'key' => 'field_5254646bd0fbc',
				'label' => 'Telephones Title',
				'name' => 'telephones_title',
				'type' => 'text',
				'instructions' => 'Add the telephones title',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5254649ad0fbd',
				'label' => 'Telephones Numbers',
				'name' => 'telephones_numbers',
				'type' => 'wysiwyg',
				'instructions' => 'Add phone numbers',
				'default_value' => '',
				'toolbar' => 'full',
				'media_upload' => 'yes',
			),
			array (
				'key' => 'field_525464c5d0fbe',
				'label' => 'Schedule',
				'name' => 'schedule',
				'type' => 'text',
				'instructions' => 'Add the schedule title',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_525464fad0fbf',
				'label' => 'Schedule Description',
				'name' => 'schedule_description',
				'type' => 'wysiwyg',
				'instructions' => 'Add schedule description',
				'default_value' => '',
				'toolbar' => 'full',
				'media_upload' => 'yes',
			),
			array (
				'key' => 'field_5254519a6e719',
				'label' => 'Map Info',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_52555f9172757',
				'label' => 'Disable map',
				'name' => 'disable_map',
				'type' => 'true_false',
				'instructions' => 'Disable map if there is no location to display',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5254574a26a74',
				'label' => 'Map Title',
				'name' => 'map_title',
				'type' => 'text',
				'instructions' => 'Add map title here',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_52555f2072756',
				'label' => 'Map Grayscale',
				'name' => 'map_grayscale',
				'type' => 'true_false',
				'instructions' => 'Map on grayscale or not',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_5254579e8f64f',
				'label' => 'Map Zoom',
				'name' => 'map_zoom',
				'type' => 'number',
				'instructions' => 'Add the level how deep the map should go',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'min' => '',
				'max' => '',
				'step' => '',
			),
			array (
				'key' => 'field_525452426180e',
				'label' => 'Map',
				'name' => 'map',
				'type' => 'googlemap',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'template-contact.php',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_footer',
		'title' => 'Footer',
		'fields' => array (
			array (
				'key' => 'field_522484235ff28',
				'label' => 'Copy Rights',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_52247c3314e69',
				'label' => 'Copy Right Text',
				'name' => 'copy_right_text',
				'type' => 'wysiwyg',
				'instructions' => 'Add The copy right text',
				'default_value' => '',
				'toolbar' => 'full',
				'media_upload' => 'yes',
			),
			array (
				'key' => 'field_522484335ff29',
				'label' => 'Social Networks',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_52247c5e8207f',
				'label' => 'Social Networks',
				'name' => 'social_networks',
				'type' => 'repeater',
				'instructions' => 'Add Social Networks',
				'sub_fields' => array (
					array (
						'key' => 'field_52247cf101a24',
						'label' => 'Network',
						'name' => 'network',
						'type' => 'select',
						'instructions' => 'Choose a Network',
						'column_width' => '',
						'choices' => array (
							'icon-facebook' => 'Facebook',
							'icon-twitter' => 'Twitter',
							'icon-pinterest' => 'Pinterest',
							'icon-tumblr' => 'Tumblr',
							'icon-flickr' => 'Flickr',
							'icon-google-plus' => 'Google+',
							'icon-linkedin' => 'LinkedIn',
							'icon-dribbble' => 'Dribbble',
							'icon-youtube' => 'Youtube',
						),
						'default_value' => '',
						'allow_null' => 0,
						'multiple' => 0,
					),
					array (
						'key' => 'field_52247d0401a25',
						'label' => 'Url',
						'name' => 'url',
						'type' => 'text',
						'instructions' => 'The Url to the network',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => '',
					),
				),
				'row_min' => 0,
				'row_limit' => '',
				'layout' => 'table',
				'button_label' => 'Add Row',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'options_page',
					'operator' => '==',
					'value' => 'acf-options-footer',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_header',
		'title' => 'Header',
		'fields' => array (
			array (
				'key' => 'field_52246d5b0590a',
				'label' => 'Site Icon',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_52246d81b0ceb',
				'label' => 'Site Favicon',
				'name' => 'site_favicon',
				'type' => 'image',
				'save_format' => 'url',
				'preview_size' => 'thumbnail',
				'library' => 'all',
			),
			array (
				'key' => 'field_522474843ac28',
				'label' => 'Logo',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_52246df6636ce',
				'label' => 'Logo',
				'name' => 'logo',
				'type' => 'image',
				'save_format' => 'id',
				'preview_size' => 'logo',
				'library' => 'all',
			),
			
			array (
				'key' => 'field_5319909c2b294',
				'label' => 'Logo Width',
				'name' => 'logo_width',
				'type' => 'number',
				'instructions' => 'Set the width of logo',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'min' => '',
				'max' => '',
				'step' => '',
			),
			array (
				'key' => 'field_531990c82b295',
				'label' => 'Logo Height',
				'name' => 'logo_height',
				'type' => 'number',
				'instructions' => 'Set the height of logo',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'min' => '',
				'max' => '',
				'step' => '',
			),
			
			array (
				'key' => 'field_52246e8f0771c',
				'label' => 'Text Logo',
				'name' => 'text_logo',
				'type' => 'text',
				'instructions' => 'Add Text as logo. Note: this text only shows if you do not insert a logo image',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5224712759c18',
				'label' => 'Text Logo Color',
				'name' => 'text_logo_color',
				'type' => 'color_picker',
				'instructions' => 'Choose a color to the text logo',
				'default_value' => '#000000',
			),
			array (
				'key' => 'field_522470fdb6ea1',
				'label' => 'Text Logo Font',
				'name' => 'text_logo_font',
				'type' => 'googlefonts',
				'instructions' => 'Choose the text logo font (Google fonts)',
			),
			array (
				'key' => 'field_522471856ef70',
				'label' => 'Text Font Size',
				'name' => 'text_font_size',
				'type' => 'number',
				'instructions' => 'Choose the size of the logo font',
				'default_value' => 50,
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'min' => '',
				'max' => '',
				'step' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'options_page',
					'operator' => '==',
					'value' => 'acf-options-header',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_home-1',
		'title' => 'Home 1',
		'fields' => array (
			array (
				'key' => 'field_523186278b44e',
				'label' => 'Latest Works',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_523186418b44f',
				'label' => 'Latest Work',
				'name' => 'latest_work',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_523186608b450',
				'label' => 'Items on Slider',
				'name' => 'items_on_slider',
				'type' => 'select',
				'choices' => array (
					'span1' => 12,
					'span2' => 6,
					'span3' => 4,
					'span4' => 3,
					'span6' => 2,
					'span12' => 1,
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_527e3b839cf12',
				'label' => 'Header',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_529f3851c7a28',
				'label' => 'Disable Header',
				'name' => 'disable_header',
				'type' => 'true_false',
				'instructions' => 'Disable this big header',
				'default_value' => 0,
				'placeholder' => '',
				'maxlength' => '',
				'formatting' => 'br',
				'message' => '',
			),
			array (
				'key' => 'field_527e3acd52b35',
				'label' => 'Header Title',
				'name' => 'header_title',
				'type' => 'text',
				'instructions' => 'Add a header title which will be displayed below the menu',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_527e3b1752b36',
				'label' => 'Header Desc',
				'name' => 'header_desc',
				'type' => 'text',
				'instructions' => 'Add a header description which will be displayed on header',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_527e3b3252b37',
				'label' => 'Header Link',
				'name' => 'header_link',
				'type' => 'text',
				'instructions' => 'Add a header link',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_527e3c2584db3',
				'label' => 'Header Backgroud Color',
				'name' => 'header_backgroud_color',
				'type' => 'color_picker',
				'instructions' => 'Choose header background color',
				'default_value' => '',
			),
			array (
				'key' => 'field_527e3c7b84db4',
				'label' => 'Text Color',
				'name' => 'text_color',
				'type' => 'color_picker',
				'instructions' => 'Choose text color',
				'default_value' => '',
			),
			array (
				'key' => 'field_527e3c9284db5',
				'label' => 'Font',
				'name' => 'font',
				'type' => 'googlefonts',
				'instructions' => 'Add a font for header',
			),
			array (
				'key' => 'field_527e3cd184db6',
				'label' => 'Icon',
				'name' => 'icon',
				'type' => 'select',
				'instructions' => 'Choose a font awsome icon ',
				'choices' => array (
					'none' => 'none',
'icon-glass' => '&#xf000;',
'icon-music' => '&#xf001;',
'icon-search' => '&#xf002;',
'icon-envelope-alt' => '&#xf003;',
'icon-heart' => '&#xf004;',
'icon-star' => '&#xf005;',
'icon-star-empty' => '&#xf006;',
'icon-user"' => '&#xf007;',
'icon-film' => '&#xf008;',
'icon-th-large' => '&#xf009;',
'icon-th' => '&#xf00a;',
'icon-th-list' => '&#xf00b;',
'icon-ok' => '&#xf00c;',
'icon-remove' => '&#xf00d;',
'icon-zoom-in' => '&#xf00e;',
'icon-zoom-out' => '&#xf010;',
'icon-off' => '&#xf011;',
'icon-signal' => '&#xf012;',
'icon-cog' => '&#xf013;',
'icon-trash' => '&#xf014;',
'icon-home' => '&#xf015;',
'icon-file-alt' => '&#xf016;',
'icon-time' => '&#xf017;',
'icon-road' => '&#xf018;',
'icon-download-alt' => '&#xf019;',
'icon-download' => '&#xf01a;',
'icon-upload' => '&#xf01b;',
'icon-inbox' => '&#xf01c;',
'icon-play-circle' => '&#xf01d;',
'icon-repeat' => '&#xf01e;',
'icon-refresh' => '&#xf021;',
'icon-list-alt' => '&#xf022;',
'icon-lock' => '&#xf023;',
'icon-flag' => '&#xf024;',
'icon-headphones' => '&#xf025;',
'icon-volume-off' => '&#xf026;',
'icon-volume-down' => '&#xf027;',
'icon-volume-up' => '&#xf028;',
'icon-qrcode' => '&#xf029;',
'icon-barcode' => '&#xf02a;',
'icon-tag' => '&#xf02b;',
'icon-tags' => '&#xf02c;',
'icon-book' => '&#xf02d;',
'icon-bookmark' => '&#xf02e;',
'icon-print' => '&#xf02f;',
'icon-camera' => '&#xf030;',
'icon-font' => '&#xf031;',
'icon-bold' => '&#xf032;',
'icon-italic' => '&#xf033;',
'icon-text-height' => '&#xf034;',
'icon-text-width' => '&#xf035;',
'icon-align-left' => '&#xf036;',
'icon-align-center' => '&#xf037;',
'icon-align-right' => '&#xf038;',
'icon-align-justify' => '&#xf039;',
'icon-list' => '&#xf03a;',
'icon-indent-left' => '&#xf03b;',
'icon-indent-right' => '&#xf03c;',
'icon-facetime-video' => '&#xf03d;',
'icon-picture' => '&#xf03e;',
'icon-pencil' => '&#xf040;',
'icon-map-marker' => '&#xf041;',
'icon-adjust' => '&#xf042;',
'icon-tint' => '&#xf043;',
'icon-edit' => '&#xf044;',
'icon-share' => '&#xf045;',
'icon-check' => '&#xf046;',
'icon-move' => '&#xf047;',
'icon-step-backward' => '&#xf048;',
'icon-fast-backward' => '&#xf049;',
'icon-backward' => '&#xf04a;',
'icon-play' => '&#xf04b;',
'icon-pause' => '&#xf04c;',
'icon-stop' => '&#xf04d;',
'icon-forward' => '&#xf04e;',
'icon-fast-forward' => '&#xf050;',
'icon-step-forward' => '&#xf051;',
'icon-eject' => '&#xf052;',
'icon-chevron-left' => '&#xf053;',
'icon-chevron-right' => '&#xf054;',
'icon-plus-sign' => '&#xf055;',
'icon-minus-sign' => '&#xf056;',
'icon-remove-sign' => '&#xf057;',
'icon-ok-sign' => '&#xf058;',
'icon-question-sign' => '&#xf059;',
'icon-info-sign' => '&#xf05a;',
'icon-screenshot' => '&#xf05b;',
'icon-remove-circle' => '&#xf05c;',
'icon-ok-circle' => '&#xf05d;',
'icon-ban-circle' => '&#xf05e;',
'icon-arrow-left' => '&#xf060;',
'icon-arrow-right' => '&#xf061;',
'icon-arrow-up' => '&#xf062;',
'icon-arrow-down' => '&#xf063;',
'icon-share-alt' => '&#xf064;',
'icon-resize-full' => '&#xf065;',
'icon-resize-small' => '&#xf066;',
'icon-plus' => '&#xf067;',
'icon-minus' => '&#xf068;',
'icon-asterisk' => '&#xf069;',
'icon-exclamation-sign' => '&#xf06a;',
'icon-gift' => '&#xf06b;',
'icon-leaf' => '&#xf06c;',
'icon-fire' => '&#xf06d;',
'icon-eye-open' => '&#xf06e;',
'icon-eye-close' => '&#xf070;',
'icon-warning-sign' => '&#xf071;',
'icon-plane' => '&#xf072;',
'icon-calendar' => '&#xf073;',
'icon-random' => '&#xf074;',
'icon-comment' => '&#xf075;',
'icon-magnet' => '&#xf076;',
'icon-chevron-up' => '&#xf077;',
'icon-chevron-down' => '&#xf078;',
'icon-retweet' => '&#xf079;',
'icon-shopping-cart' => '&#xf07a;',
'icon-folder-close' => '&#xf07b;',
'icon-folder-open' => '&#xf07c;',
'icon-resize-vertical' => '&#xf07d;',
'icon-resize-horizontal' => '&#xf07e;',
'icon-bar-chart' => '&#xf080;',
'icon-twitter-sign' => '&#xf081;',
'icon-facebook-sign' => '&#xf082;',
'icon-camera-retro' => '&#xf083;',
'icon-key' => '&#xf084;',
'icon-cogs' => '&#xf085;',
'icon-comments' => '&#xf086;',
'icon-thumbs-up-alt' => '&#xf087;',
'icon-thumbs-down-alt' => '&#xf088;',
'icon-star-half' => '&#xf089;',
'icon-heart-empty' => '&#xf08a;',
'icon-signout' => '&#xf08b;',
'icon-linkedin-sign' => '&#xf08c;',
'icon-pushpin' => '&#xf08d;',
'icon-external-link' => '&#xf08e;',
'icon-signin' => '&#xf090;',
'icon-trophy' => '&#xf091;',
'icon-github-sign' => '&#xf092;',
'icon-upload-alt' => '&#xf093;',
'icon-lemon' => '&#xf094;',
'icon-phone' => '&#xf095;',
'icon-check-empty' => '&#xf096;',
'icon-bookmark-empty' => '&#xf097;',
'icon-phone-sign' => '&#xf098;',
'icon-twitter' => '&#xf099;',
'icon-facebook' => '&#xf09a;',
'icon-github' => '&#xf09b;',
'icon-unlock' => '&#xf09c;',
'icon-credit-card' => '&#xf09d;',
'icon-rss' => '&#xf09e;',
'icon-hdd' => '&#xf0a0;',
'icon-bullhorn' => '&#xf0a1;',
'icon-bell' => '&#xf0a2;',
'icon-certificate' => '&#xf0a3;',
'icon-hand-right' => '&#xf0a4;',
'icon-hand-left' => '&#xf0a5;',
'icon-hand-up' => '&#xf0a6;',
'icon-hand-down' => '&#xf0a7;',
'icon-circle-arrow-left' => '&#xf0a8;',
'icon-circle-arrow-right' => '&#xf0a9;',
'icon-circle-arrow-up' => '&#xf0aa;',
'icon-circle-arrow-down' => '&#xf0ab;',
'icon-globe' => '&#xf0ac;',
'icon-wrench' => '&#xf0ad;',
'icon-tasks' => '&#xf0ae;',
'icon-filter' => '&#xf0b0;',
'icon-briefcase' => '&#xf0b1;',
'icon-fullscreen' => '&#xf0b2;',
'icon-group' => '&#xf0c0;',
'icon-link' => '&#xf0c1;',
'icon-cloud' => '&#xf0c2;',
'icon-beaker' => '&#xf0c3;',
'icon-cut' => '&#xf0c4;',
'icon-copy' => '&#xf0c5;',
'icon-paper-clip' => '&#xf0c6;',
'icon-save' => '&#xf0c7;',
'icon-sign-blank' => '&#xf0c8;',
'icon-reorder' => '&#xf0c9;',
'icon-list-ul' => '&#xf0ca;',
'icon-list-ol' => '&#xf0cb;',
'icon-strikethrough' => '&#xf0cc;',
'icon-underline' => '&#xf0cd;',
'icon-table' => '&#xf0ce;',
'icon-magic' => '&#xf0d0;',
'icon-truck' => '&#xf0d1;',
'icon-pinterest' => '&#xf0d2;',
'icon-pinterest-sign' => '&#xf0d3;',
'icon-google-plus-sign' => '&#xf0d4;',
'icon-google-plus' => '&#xf0d5;',
'icon-money' => '&#xf0d6;',
'icon-caret-down' => '&#xf0d7;',
'icon-caret-up' => '&#xf0d8;',
'icon-caret-left' => '&#xf0d9;',
'icon-caret-right' => '&#xf0da;',
'icon-columns' => '&#xf0db;',
'icon-sort' => '&#xf0dc;',
'icon-sort-down' => '&#xf0dd;',
'icon-sort-up' => '&#xf0de;',
'icon-envelope' => '&#xf0e0;',
'icon-linkedin' => '&#xf0e1;',
'icon-undo' => '&#xf0e2;',
'icon-legal' => '&#xf0e3;',
'icon-dashboard' => '&#xf0e4;',
'icon-comment-alt' => '&#xf0e5;',
'icon-comments-alt' => '&#xf0e6;',
'icon-bolt' => '&#xf0e7;',
'icon-sitemap' => '&#xf0e8;',
'icon-umbrella' => '&#xf0e9;',
'icon-paste' => '&#xf0ea;',
'icon-lightbulb' => '&#xf0eb;',
'icon-exchange' => '&#xf0ec;',
'icon-cloud-download' => '&#xf0ed;',
'icon-cloud-upload' => '&#xf0ee;',
'icon-user-md' => '&#xf0f0;',
'icon-stethoscope' => '&#xf0f1;',
'icon-suitcase' => '&#xf0f2;',
'icon-bell-alt' => '&#xf0f3;',
'icon-coffee' => '&#xf0f4;',
'icon-food' => '&#xf0f5;',
'icon-file-text-alt' => '&#xf0f6;',
'icon-building' => '&#xf0f7;',
'icon-hospital' => '&#xf0f8;',
'icon-ambulance' => '&#xf0f9;',
'icon-medkit' => '&#xf0fa;',
'icon-fighter-jet' => '&#xf0fb;',
'icon-beer' => '&#xf0fc;',
'icon-h-sign' => '&#xf0fd;',
'icon-plus-sign-alt' => '&#xf0fe;',
'icon-double-angle-left' => '&#xf100;',
'icon-double-angle-right' => '&#xf101;',
'icon-double-angle-up' => '&#xf102;',
'icon-double-angle-down' => '&#xf103;',
'icon-angle-left' => '&#xf104;',
'icon-angle-right' => '&#xf105;',
'icon-angle-up' => '&#xf106;',
'icon-angle-down' => '&#xf107;',
'icon-desktop' => '&#xf108;',
'icon-laptop' => '&#xf109;',
'icon-tablet' => '&#xf10a;',
'icon-mobile-phone' => '&#xf10b;',
'icon-circle-blank' => '&#xf10c;',
'icon-quote-left' => '&#xf10d;',
'icon-quote-right' => '&#xf10e;',
'icon-spinner' => '&#xf110;',
'icon-circle' => '&#xf111;',
'icon-reply' => '&#xf112;',
'icon-github-alt' => '&#xf113;',
'icon-folder-close-alt' => '&#xf114;',
'icon-folder-open-alt' => '&#xf115;',
'icon-expand-alt' => '&#xf116;',
'icon-collapse-alt' => '&#xf117;',
'icon-smile' => '&#xf118;',
'icon-frown' => '&#xf119;',
'icon-meh' => '&#xf11a;',
'icon-gamepad' => '&#xf11b;',
'icon-keyboard' => '&#xf11c;',
'icon-flag-alt' => '&#xf11d;',
'icon-flag-checkered' => '&#xf11e;',
'icon-terminal' => '&#xf120;',
'icon-code' => '&#xf121;',
'icon-reply-all' => '&#xf122;',
'icon-mail-reply-all' => '&#xf122;',
'icon-star-half-empty' => '&#xf123;',
'icon-location-arrow' => '&#xf124;',
'icon-crop' => '&#xf125;',
'icon-code-fork' => '&#xf126;',
'icon-unlink' => '&#xf127;',
'icon-question' => '&#xf128;',
'icon-info' => '&#xf129;',
'icon-exclamation' => '&#xf12a;',
'icon-superscript' => '&#xf12b;',
'icon-subscript' => '&#xf12c;',
'icon-eraser' => '&#xf12d;',
'icon-puzzle-piece' => '&#xf12e;',
'icon-microphone' => '&#xf130;',
'icon-microphone-off' => '&#xf131;',
'icon-shield' => '&#xf132;',
'icon-calendar-empty' => '&#xf133;',
'icon-fire-extinguisher' => '&#xf134;',
'icon-rocket' => '&#xf135;',
'icon-maxcdn' => '&#xf136;',
'icon-chevron-sign-left' => '&#xf137;',
'icon-chevron-sign-right' => '&#xf138;',
'icon-chevron-sign-up' => '&#xf139;',
'icon-chevron-sign-down' => '&#xf13a;',
'icon-html5' => '&#xf13b;',
'icon-css3' => '&#xf13c;',
'icon-anchor' => '&#xf13d;',
'icon-unlock-alt' => '&#xf13e;',
'icon-bullseye' => '&#xf140;',
'icon-ellipsis-horizontal' => '&#xf141;',
'icon-ellipsis-vertical' => '&#xf142;',
'icon-rss-sign' => '&#xf143;',
'icon-play-sign' => '&#xf144;',
'icon-ticket' => '&#xf145;',
'icon-minus-sign-alt' => '&#xf146;',
'icon-check-minus' => '&#xf147;',
'icon-level-up' => '&#xf148;',
'icon-level-down' => '&#xf149;',
'icon-check-sign' => '&#xf14a;',
'icon-edit-sign' => '&#xf14b;',
'icon-external-link-sign' => '&#xf14c;',
'icon-share-sign' => '&#xf14d;',
'icon-compass' => '&#xf14e;',
'icon-collapse' => '&#xf150;',
'icon-collapse-top' => '&#xf151;',
'icon-expand' => '&#xf152;',
'icon-eur' => '&#xf153;',
'icon-gbp' => '&#xf154;',
'icon-usd' => '&#xf155;',
'icon-inr' => '&#xf156;',
'icon-jpy' => '&#xf157;',
'icon-cny' => '&#xf158;',
'icon-krw' => '&#xf159;',
'icon-btc' => '&#xf15a;',
'icon-file' => '&#xf15b;',
'icon-file-text' => '&#xf15c;',
'icon-sort-by-alphabet' => '&#xf15d;',
'icon-sort-by-alphabet-alt' => '&#xf15e;',
'icon-sort-by-attributes' => '&#xf160;',
'icon-sort-by-attributes-alt' => '&#xf161;',
'icon-sort-by-order' => '&#xf162;',
'icon-sort-by-order-alt' => '&#xf163;',
'icon-thumbs-up' => '&#xf164;',
'icon-thumbs-down' => '&#xf165;',
'icon-youtube-sign' => '&#xf166;',
'icon-youtube' => '&#xf167;',
'icon-xing' => '&#xf168;',
'icon-xing-sign' => '&#xf169;',
'icon-youtube-play' => '&#xf16a;',
'icon-dropbox' => '&#xf16b;',
'icon-stackexchange' => '&#xf16c;',
'icon-instagram' => '&#xf16d;',
'icon-flickr' => '&#xf16e;',
'icon-adn' => '&#xf170;',
'icon-bitbucket' => '&#xf171;',
'icon-bitbucket-sign' => '&#xf172;',
'icon-tumblr' => '&#xf173;',
'icon-tumblr-sign' => '&#xf174;',
'icon-long-arrow-down' => '&#xf175;',
'icon-long-arrow-up' => '&#xf176;',
'icon-long-arrow-left' => '&#xf177;',
'icon-long-arrow-right' => '&#xf178;',
'icon-apple' => '&#xf179;',
'icon-windows' => '&#xf17a;',
'icon-android' => '&#xf17b;',
'icon-linux' => '&#xf17c;',
'icon-dribbble' => '&#xf17d;',
'icon-skype' => '&#xf17e;',
'icon-foursquare' => '&#xf180;',
'icon-trello' => '&#xf181;',
'icon-female' => '&#xf182;',
'icon-male' => '&#xf183;',
'icon-gittip' => '&#xf184;',
'icon-sun' => '&#xf185;',
'icon-moon' => '&#xf186;',
'icon-archive' => '&#xf187;',
'icon-bug' => '&#xf188;',
'icon-vk' => '&#xf189;',
'icon-weibo' => '&#xf18a;',
'icon-renren' => '&#xf18b;',
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0,
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'template-home1.php',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_home-2',
		'title' => 'Home 2',
		'fields' => array (
			array (
				'key' => 'field_528e6a79b2799',
				'label' => 'Page Options',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_527270b301c8c',
				'label' => 'Page Title',
				'name' => 'page_title',
				'type' => 'text',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_528e6e04ae75b',
				'label' => 'Articles title',
				'name' => 'articles_title',
				'type' => 'text',
				'instructions' => 'Add a title for articles',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5282537cabf00',
				'label' => 'Disable Homebar',
				'name' => 'disable_homebar',
				'type' => 'true_false',
				'instructions' => 'Disable home footer sidebar',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_522f11bd00bd8',
				'label' => 'Accordions',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_528e6b1e7516a',
				'label' => 'Accordion Title',
				'name' => 'accordion_title',
				'type' => 'text',
				'instructions' => 'Add a title for accordions',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_522f115be87ec',
				'label' => 'Accordions',
				'name' => 'accordions',
				'type' => 'repeater',
				'instructions' => 'Here you define the accordions',
				'sub_fields' => array (
					array (
						'key' => 'field_522f1193e87ed',
						'label' => 'Accordion_Title',
						'name' => 'accordion_title',
						'type' => 'text',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => '',
					),
					array (
						'key' => 'field_522f11a8e87ee',
						'label' => 'Accordion_Text',
						'name' => 'accordion_text',
						'type' => 'textarea',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'maxlength' => '',
						'formatting' => 'br',
					),
				),
				'row_min' => 0,
				'row_limit' => '',
				'layout' => 'table',
				'button_label' => 'Add Row',
			),
			array (
				'key' => 'field_529f36486fe2e',
				'label' => 'Header',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_529f37d6b3e44',
				'label' => 'Disable Header',
				'name' => 'disable_header',
				'type' => 'true_false',
				'instructions' => 'Disable this big header',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_529f365e6fe2f',
				'label' => 'Header Title',
				'name' => 'header_title',
				'type' => 'text',
				'instructions' => 'Add a header title which will be displayed below the menu',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_529f366d6fe30',
				'label' => 'Header Desc',
				'name' => 'header_desc',
				'type' => 'text',
				'instructions' => 'Add a header description which will be displayed on header',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_529f367a6fe31',
				'label' => 'Header Link',
				'name' => 'header_link',
				'type' => 'text',
				'instructions' => 'Add a header link',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_529f36876fe32',
				'label' => 'Header Background Color',
				'name' => 'header_background_color',
				'type' => 'color_picker',
				'instructions' => 'Choose header background color',
				'default_value' => '',
			),
			array (
				'key' => 'field_529f36996fe33',
				'label' => 'Text Color',
				'name' => 'text_color',
				'type' => 'color_picker',
				'instructions' => 'Choose text color',
				'default_value' => '',
			),
			array (
				'key' => 'field_529f36b26fe34',
				'label' => 'Font',
				'name' => 'font',
				'type' => 'googlefonts',
				'instructions' => 'Add a font for header',
			),
			array (
				'key' => 'field_529f36b96fe35',
				'label' => 'Icon',
				'name' => 'icon',
				'type' => 'select',
				'instructions' => 'Choose a font awsome icon',
				'choices' => array (
					'none' => 'none',
'icon-glass' => '&#xf000;',
'icon-music' => '&#xf001;',
'icon-search' => '&#xf002;',
'icon-envelope-alt' => '&#xf003;',
'icon-heart' => '&#xf004;',
'icon-star' => '&#xf005;',
'icon-star-empty' => '&#xf006;',
'icon-user"' => '&#xf007;',
'icon-film' => '&#xf008;',
'icon-th-large' => '&#xf009;',
'icon-th' => '&#xf00a;',
'icon-th-list' => '&#xf00b;',
'icon-ok' => '&#xf00c;',
'icon-remove' => '&#xf00d;',
'icon-zoom-in' => '&#xf00e;',
'icon-zoom-out' => '&#xf010;',
'icon-off' => '&#xf011;',
'icon-signal' => '&#xf012;',
'icon-cog' => '&#xf013;',
'icon-trash' => '&#xf014;',
'icon-home' => '&#xf015;',
'icon-file-alt' => '&#xf016;',
'icon-time' => '&#xf017;',
'icon-road' => '&#xf018;',
'icon-download-alt' => '&#xf019;',
'icon-download' => '&#xf01a;',
'icon-upload' => '&#xf01b;',
'icon-inbox' => '&#xf01c;',
'icon-play-circle' => '&#xf01d;',
'icon-repeat' => '&#xf01e;',
'icon-refresh' => '&#xf021;',
'icon-list-alt' => '&#xf022;',
'icon-lock' => '&#xf023;',
'icon-flag' => '&#xf024;',
'icon-headphones' => '&#xf025;',
'icon-volume-off' => '&#xf026;',
'icon-volume-down' => '&#xf027;',
'icon-volume-up' => '&#xf028;',
'icon-qrcode' => '&#xf029;',
'icon-barcode' => '&#xf02a;',
'icon-tag' => '&#xf02b;',
'icon-tags' => '&#xf02c;',
'icon-book' => '&#xf02d;',
'icon-bookmark' => '&#xf02e;',
'icon-print' => '&#xf02f;',
'icon-camera' => '&#xf030;',
'icon-font' => '&#xf031;',
'icon-bold' => '&#xf032;',
'icon-italic' => '&#xf033;',
'icon-text-height' => '&#xf034;',
'icon-text-width' => '&#xf035;',
'icon-align-left' => '&#xf036;',
'icon-align-center' => '&#xf037;',
'icon-align-right' => '&#xf038;',
'icon-align-justify' => '&#xf039;',
'icon-list' => '&#xf03a;',
'icon-indent-left' => '&#xf03b;',
'icon-indent-right' => '&#xf03c;',
'icon-facetime-video' => '&#xf03d;',
'icon-picture' => '&#xf03e;',
'icon-pencil' => '&#xf040;',
'icon-map-marker' => '&#xf041;',
'icon-adjust' => '&#xf042;',
'icon-tint' => '&#xf043;',
'icon-edit' => '&#xf044;',
'icon-share' => '&#xf045;',
'icon-check' => '&#xf046;',
'icon-move' => '&#xf047;',
'icon-step-backward' => '&#xf048;',
'icon-fast-backward' => '&#xf049;',
'icon-backward' => '&#xf04a;',
'icon-play' => '&#xf04b;',
'icon-pause' => '&#xf04c;',
'icon-stop' => '&#xf04d;',
'icon-forward' => '&#xf04e;',
'icon-fast-forward' => '&#xf050;',
'icon-step-forward' => '&#xf051;',
'icon-eject' => '&#xf052;',
'icon-chevron-left' => '&#xf053;',
'icon-chevron-right' => '&#xf054;',
'icon-plus-sign' => '&#xf055;',
'icon-minus-sign' => '&#xf056;',
'icon-remove-sign' => '&#xf057;',
'icon-ok-sign' => '&#xf058;',
'icon-question-sign' => '&#xf059;',
'icon-info-sign' => '&#xf05a;',
'icon-screenshot' => '&#xf05b;',
'icon-remove-circle' => '&#xf05c;',
'icon-ok-circle' => '&#xf05d;',
'icon-ban-circle' => '&#xf05e;',
'icon-arrow-left' => '&#xf060;',
'icon-arrow-right' => '&#xf061;',
'icon-arrow-up' => '&#xf062;',
'icon-arrow-down' => '&#xf063;',
'icon-share-alt' => '&#xf064;',
'icon-resize-full' => '&#xf065;',
'icon-resize-small' => '&#xf066;',
'icon-plus' => '&#xf067;',
'icon-minus' => '&#xf068;',
'icon-asterisk' => '&#xf069;',
'icon-exclamation-sign' => '&#xf06a;',
'icon-gift' => '&#xf06b;',
'icon-leaf' => '&#xf06c;',
'icon-fire' => '&#xf06d;',
'icon-eye-open' => '&#xf06e;',
'icon-eye-close' => '&#xf070;',
'icon-warning-sign' => '&#xf071;',
'icon-plane' => '&#xf072;',
'icon-calendar' => '&#xf073;',
'icon-random' => '&#xf074;',
'icon-comment' => '&#xf075;',
'icon-magnet' => '&#xf076;',
'icon-chevron-up' => '&#xf077;',
'icon-chevron-down' => '&#xf078;',
'icon-retweet' => '&#xf079;',
'icon-shopping-cart' => '&#xf07a;',
'icon-folder-close' => '&#xf07b;',
'icon-folder-open' => '&#xf07c;',
'icon-resize-vertical' => '&#xf07d;',
'icon-resize-horizontal' => '&#xf07e;',
'icon-bar-chart' => '&#xf080;',
'icon-twitter-sign' => '&#xf081;',
'icon-facebook-sign' => '&#xf082;',
'icon-camera-retro' => '&#xf083;',
'icon-key' => '&#xf084;',
'icon-cogs' => '&#xf085;',
'icon-comments' => '&#xf086;',
'icon-thumbs-up-alt' => '&#xf087;',
'icon-thumbs-down-alt' => '&#xf088;',
'icon-star-half' => '&#xf089;',
'icon-heart-empty' => '&#xf08a;',
'icon-signout' => '&#xf08b;',
'icon-linkedin-sign' => '&#xf08c;',
'icon-pushpin' => '&#xf08d;',
'icon-external-link' => '&#xf08e;',
'icon-signin' => '&#xf090;',
'icon-trophy' => '&#xf091;',
'icon-github-sign' => '&#xf092;',
'icon-upload-alt' => '&#xf093;',
'icon-lemon' => '&#xf094;',
'icon-phone' => '&#xf095;',
'icon-check-empty' => '&#xf096;',
'icon-bookmark-empty' => '&#xf097;',
'icon-phone-sign' => '&#xf098;',
'icon-twitter' => '&#xf099;',
'icon-facebook' => '&#xf09a;',
'icon-github' => '&#xf09b;',
'icon-unlock' => '&#xf09c;',
'icon-credit-card' => '&#xf09d;',
'icon-rss' => '&#xf09e;',
'icon-hdd' => '&#xf0a0;',
'icon-bullhorn' => '&#xf0a1;',
'icon-bell' => '&#xf0a2;',
'icon-certificate' => '&#xf0a3;',
'icon-hand-right' => '&#xf0a4;',
'icon-hand-left' => '&#xf0a5;',
'icon-hand-up' => '&#xf0a6;',
'icon-hand-down' => '&#xf0a7;',
'icon-circle-arrow-left' => '&#xf0a8;',
'icon-circle-arrow-right' => '&#xf0a9;',
'icon-circle-arrow-up' => '&#xf0aa;',
'icon-circle-arrow-down' => '&#xf0ab;',
'icon-globe' => '&#xf0ac;',
'icon-wrench' => '&#xf0ad;',
'icon-tasks' => '&#xf0ae;',
'icon-filter' => '&#xf0b0;',
'icon-briefcase' => '&#xf0b1;',
'icon-fullscreen' => '&#xf0b2;',
'icon-group' => '&#xf0c0;',
'icon-link' => '&#xf0c1;',
'icon-cloud' => '&#xf0c2;',
'icon-beaker' => '&#xf0c3;',
'icon-cut' => '&#xf0c4;',
'icon-copy' => '&#xf0c5;',
'icon-paper-clip' => '&#xf0c6;',
'icon-save' => '&#xf0c7;',
'icon-sign-blank' => '&#xf0c8;',
'icon-reorder' => '&#xf0c9;',
'icon-list-ul' => '&#xf0ca;',
'icon-list-ol' => '&#xf0cb;',
'icon-strikethrough' => '&#xf0cc;',
'icon-underline' => '&#xf0cd;',
'icon-table' => '&#xf0ce;',
'icon-magic' => '&#xf0d0;',
'icon-truck' => '&#xf0d1;',
'icon-pinterest' => '&#xf0d2;',
'icon-pinterest-sign' => '&#xf0d3;',
'icon-google-plus-sign' => '&#xf0d4;',
'icon-google-plus' => '&#xf0d5;',
'icon-money' => '&#xf0d6;',
'icon-caret-down' => '&#xf0d7;',
'icon-caret-up' => '&#xf0d8;',
'icon-caret-left' => '&#xf0d9;',
'icon-caret-right' => '&#xf0da;',
'icon-columns' => '&#xf0db;',
'icon-sort' => '&#xf0dc;',
'icon-sort-down' => '&#xf0dd;',
'icon-sort-up' => '&#xf0de;',
'icon-envelope' => '&#xf0e0;',
'icon-linkedin' => '&#xf0e1;',
'icon-undo' => '&#xf0e2;',
'icon-legal' => '&#xf0e3;',
'icon-dashboard' => '&#xf0e4;',
'icon-comment-alt' => '&#xf0e5;',
'icon-comments-alt' => '&#xf0e6;',
'icon-bolt' => '&#xf0e7;',
'icon-sitemap' => '&#xf0e8;',
'icon-umbrella' => '&#xf0e9;',
'icon-paste' => '&#xf0ea;',
'icon-lightbulb' => '&#xf0eb;',
'icon-exchange' => '&#xf0ec;',
'icon-cloud-download' => '&#xf0ed;',
'icon-cloud-upload' => '&#xf0ee;',
'icon-user-md' => '&#xf0f0;',
'icon-stethoscope' => '&#xf0f1;',
'icon-suitcase' => '&#xf0f2;',
'icon-bell-alt' => '&#xf0f3;',
'icon-coffee' => '&#xf0f4;',
'icon-food' => '&#xf0f5;',
'icon-file-text-alt' => '&#xf0f6;',
'icon-building' => '&#xf0f7;',
'icon-hospital' => '&#xf0f8;',
'icon-ambulance' => '&#xf0f9;',
'icon-medkit' => '&#xf0fa;',
'icon-fighter-jet' => '&#xf0fb;',
'icon-beer' => '&#xf0fc;',
'icon-h-sign' => '&#xf0fd;',
'icon-plus-sign-alt' => '&#xf0fe;',
'icon-double-angle-left' => '&#xf100;',
'icon-double-angle-right' => '&#xf101;',
'icon-double-angle-up' => '&#xf102;',
'icon-double-angle-down' => '&#xf103;',
'icon-angle-left' => '&#xf104;',
'icon-angle-right' => '&#xf105;',
'icon-angle-up' => '&#xf106;',
'icon-angle-down' => '&#xf107;',
'icon-desktop' => '&#xf108;',
'icon-laptop' => '&#xf109;',
'icon-tablet' => '&#xf10a;',
'icon-mobile-phone' => '&#xf10b;',
'icon-circle-blank' => '&#xf10c;',
'icon-quote-left' => '&#xf10d;',
'icon-quote-right' => '&#xf10e;',
'icon-spinner' => '&#xf110;',
'icon-circle' => '&#xf111;',
'icon-reply' => '&#xf112;',
'icon-github-alt' => '&#xf113;',
'icon-folder-close-alt' => '&#xf114;',
'icon-folder-open-alt' => '&#xf115;',
'icon-expand-alt' => '&#xf116;',
'icon-collapse-alt' => '&#xf117;',
'icon-smile' => '&#xf118;',
'icon-frown' => '&#xf119;',
'icon-meh' => '&#xf11a;',
'icon-gamepad' => '&#xf11b;',
'icon-keyboard' => '&#xf11c;',
'icon-flag-alt' => '&#xf11d;',
'icon-flag-checkered' => '&#xf11e;',
'icon-terminal' => '&#xf120;',
'icon-code' => '&#xf121;',
'icon-reply-all' => '&#xf122;',
'icon-mail-reply-all' => '&#xf122;',
'icon-star-half-empty' => '&#xf123;',
'icon-location-arrow' => '&#xf124;',
'icon-crop' => '&#xf125;',
'icon-code-fork' => '&#xf126;',
'icon-unlink' => '&#xf127;',
'icon-question' => '&#xf128;',
'icon-info' => '&#xf129;',
'icon-exclamation' => '&#xf12a;',
'icon-superscript' => '&#xf12b;',
'icon-subscript' => '&#xf12c;',
'icon-eraser' => '&#xf12d;',
'icon-puzzle-piece' => '&#xf12e;',
'icon-microphone' => '&#xf130;',
'icon-microphone-off' => '&#xf131;',
'icon-shield' => '&#xf132;',
'icon-calendar-empty' => '&#xf133;',
'icon-fire-extinguisher' => '&#xf134;',
'icon-rocket' => '&#xf135;',
'icon-maxcdn' => '&#xf136;',
'icon-chevron-sign-left' => '&#xf137;',
'icon-chevron-sign-right' => '&#xf138;',
'icon-chevron-sign-up' => '&#xf139;',
'icon-chevron-sign-down' => '&#xf13a;',
'icon-html5' => '&#xf13b;',
'icon-css3' => '&#xf13c;',
'icon-anchor' => '&#xf13d;',
'icon-unlock-alt' => '&#xf13e;',
'icon-bullseye' => '&#xf140;',
'icon-ellipsis-horizontal' => '&#xf141;',
'icon-ellipsis-vertical' => '&#xf142;',
'icon-rss-sign' => '&#xf143;',
'icon-play-sign' => '&#xf144;',
'icon-ticket' => '&#xf145;',
'icon-minus-sign-alt' => '&#xf146;',
'icon-check-minus' => '&#xf147;',
'icon-level-up' => '&#xf148;',
'icon-level-down' => '&#xf149;',
'icon-check-sign' => '&#xf14a;',
'icon-edit-sign' => '&#xf14b;',
'icon-external-link-sign' => '&#xf14c;',
'icon-share-sign' => '&#xf14d;',
'icon-compass' => '&#xf14e;',
'icon-collapse' => '&#xf150;',
'icon-collapse-top' => '&#xf151;',
'icon-expand' => '&#xf152;',
'icon-eur' => '&#xf153;',
'icon-gbp' => '&#xf154;',
'icon-usd' => '&#xf155;',
'icon-inr' => '&#xf156;',
'icon-jpy' => '&#xf157;',
'icon-cny' => '&#xf158;',
'icon-krw' => '&#xf159;',
'icon-btc' => '&#xf15a;',
'icon-file' => '&#xf15b;',
'icon-file-text' => '&#xf15c;',
'icon-sort-by-alphabet' => '&#xf15d;',
'icon-sort-by-alphabet-alt' => '&#xf15e;',
'icon-sort-by-attributes' => '&#xf160;',
'icon-sort-by-attributes-alt' => '&#xf161;',
'icon-sort-by-order' => '&#xf162;',
'icon-sort-by-order-alt' => '&#xf163;',
'icon-thumbs-up' => '&#xf164;',
'icon-thumbs-down' => '&#xf165;',
'icon-youtube-sign' => '&#xf166;',
'icon-youtube' => '&#xf167;',
'icon-xing' => '&#xf168;',
'icon-xing-sign' => '&#xf169;',
'icon-youtube-play' => '&#xf16a;',
'icon-dropbox' => '&#xf16b;',
'icon-stackexchange' => '&#xf16c;',
'icon-instagram' => '&#xf16d;',
'icon-flickr' => '&#xf16e;',
'icon-adn' => '&#xf170;',
'icon-bitbucket' => '&#xf171;',
'icon-bitbucket-sign' => '&#xf172;',
'icon-tumblr' => '&#xf173;',
'icon-tumblr-sign' => '&#xf174;',
'icon-long-arrow-down' => '&#xf175;',
'icon-long-arrow-up' => '&#xf176;',
'icon-long-arrow-left' => '&#xf177;',
'icon-long-arrow-right' => '&#xf178;',
'icon-apple' => '&#xf179;',
'icon-windows' => '&#xf17a;',
'icon-android' => '&#xf17b;',
'icon-linux' => '&#xf17c;',
'icon-dribbble' => '&#xf17d;',
'icon-skype' => '&#xf17e;',
'icon-foursquare' => '&#xf180;',
'icon-trello' => '&#xf181;',
'icon-female' => '&#xf182;',
'icon-male' => '&#xf183;',
'icon-gittip' => '&#xf184;',
'icon-sun' => '&#xf185;',
'icon-moon' => '&#xf186;',
'icon-archive' => '&#xf187;',
'icon-bug' => '&#xf188;',
'icon-vk' => '&#xf189;',
'icon-weibo' => '&#xf18a;',
'icon-renren' => '&#xf18b;',
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0,
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'template-home2.php',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_home-3',
		'title' => 'Home 3',
		'fields' => array (
			array (
				'key' => 'field_528214ea6573a',
				'label' => 'Slider Fields',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_528214b8d5cca',
				'label' => 'Gallery',
				'name' => 'gallery',
				'type' => 'repeater',
				'instructions' => 'Add galleries with description',
				'sub_fields' => array (
					array (
						'key' => 'field_5282150460279',
						'label' => 'Image',
						'name' => 'image',
						'type' => 'image',
						'instructions' => 'Add image to display on gallery',
						'column_width' => '',
						'save_format' => 'id',
						'preview_size' => 'home3-slider',
						'library' => 'all',
					),
					array (
						'key' => 'field_528215e68c5fe',
						'label' => 'Big title',
						'name' => 'big_title',
						'type' => 'text',
						'instructions' => 'Add a title to display on image',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => '',
					),
					array (
						'key' => 'field_528216048c5ff',
						'label' => 'Small Title',
						'name' => 'small_title',
						'type' => 'text',
						'instructions' => 'Add a small title to display on image',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => '',
					),
					array (
						'key' => 'field_5282161f8c600',
						'label' => 'Desc',
						'name' => 'desc',
						'type' => 'textarea',
						'instructions' => 'Add descriptin',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'maxlength' => '',
						'formatting' => 'br',
					),
					array (
						'key' => 'field_5282162b8c601',
						'label' => 'Disable text',
						'name' => 'disable_text',
						'type' => 'true_false',
						'instructions' => 'Hide text from image',
						'column_width' => 10,
						'message' => '',
						'default_value' => 0,
					),
					array (
						'key' => 'field_5282166ed028a',
						'label' => 'Link',
						'name' => 'link',
						'type' => 'text',
						'instructions' => 'Link this image with web',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => '',
					),
					array (
						'key' => 'field_5283b3ca4f95c',
						'label' => 'Animation',
						'name' => 'animation',
						'type' => 'select',
						'column_width' => '',
						'choices' => array (
							'flash' => 'flash',
							'fadeInUp' => 'fadeInUp',
							'fadeInDown' => 'fadeInDown',
							'fadeInLeft' => 'fadeInLeft',
							'fadeInRight' => 'fadeInRight',
							'fadeInLeftBig' => 'fadeInLeftBig',
							'fadeInRightBig' => 'fadeInRightBig',
							'fadeInUpBig' => 'fadeInUpBig',
							'fadeInDownBig' => 'fadeInDownBig',
							'bounceIn' => 'bounceIn',
							'bounceInDown' => 'bounceInDown',
							'bounceInUp' => 'bounceInUp',
							'bounceInLeft' => 'bounceInLeft',
							'bounceInRight' => 'bounceInRight',
							'rotateIn' => 'rotateIn',
							'rotateInDownLeft' => 'rotateInDownLeft',
							'rotateInDownRight' => 'rotateInDownRight',
							'rotateInUpLeft' => 'rotateInUpLeft',
							'rotateInUpRight' => 'rotateInUpRight',
							'lightSpeedIn' => 'lightSpeedIn',
							'hinge' => 'hinge',
							'rollIn' => 'rollIn',
						),
						'default_value' => '',
						'allow_null' => 0,
						'multiple' => 0,
					),
				),
				'row_min' => 0,
				'row_limit' => '',
				'layout' => 'row',
				'button_label' => 'Add Row',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'template-home3.php',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_mainfields',
		'title' => 'MainFields',
		'fields' => array (
			array (
				'key' => 'field_52244f67770f7',
				'label' => 'Css and JavaScript',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_5224411b9f8e1',
				'label' => 'Custom Css',
				'name' => 'custom_css',
				'type' => 'code_area',
				'instructions' => 'Add Custom Css',
				'language' => 'css',
				'theme' => 'default',
			),
			array (
				'key' => 'field_5224414ce341f',
				'label' => 'Custom JavaScript',
				'name' => 'custom_javascript',
				'type' => 'code_area',
				'instructions' => 'Add Custom JavaScript',
				'language' => 'javascript',
				'theme' => 'default',
			),
			array (
				'key' => 'field_5224505763d11',
				'label' => 'Fonts',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_51f8bc5605d2f',
				'label' => 'Headings Font',
				'name' => 'headings_font',
				'type' => 'googlefonts',
				'instructions' => 'Choose a custom font for your website!',
			),
			array (
				'key' => 'field_5283b1e9cc03b',
				'label' => 'Paragraphs Font',
				'name' => 'paragraphs_font',
				'type' => 'googlefonts',
				'instructions' => 'Add a font for paragrafs',
			),
			array (
				'key' => 'field_526a28146e81b',
				'label' => 'Social Shares',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_526a28676e81d',
				'label' => 'Disable Blog Social Shares ',
				'name' => 'disable_blog_social_shares',
				'type' => 'true_false',
				'instructions' => 'Disable all the social shares for the blog posts',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_528f64ff29613',
				'label' => 'Disable Work Social Shares',
				'name' => 'disable_work_social_shares',
				'type' => 'true_false',
				'instructions' => 'Disable all the social shares for the work posts',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_526a28236e81c',
				'label' => 'Social Shares',
				'name' => 'social_shares',
				'type' => 'checkbox',
				'instructions' => 'Choose in which social network you want to share the posts',
				'choices' => array (
					'facebook-share' => 'Facebook',
					'twiter-share' => 'twitter',
					'google-share' => 'Google+',
					'in-share' => 'linkedIn',
					'pinterest-share' => 'Pinterest',
					'stumbleupon-share' => 'stumbleupon',
				),
				'default_value' => '',
				'layout' => 'vertical',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'options_page',
					'operator' => '==',
					'value' => 'acf-options-main',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_message',
		'title' => 'Message',
		'fields' => array (
			array (
				'key' => 'field_529e1872eeb67',
				'label' => 'Post Author',
				'name' => '',
				'type' => 'message',
				'message' => '<b>Add the author of the testimonial on the post title</b>',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'testmonials_post',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'acf_after_title',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_service-page',
		'title' => 'Service Page',
		'fields' => array (
			array (
				'key' => 'field_529f4d356bcfb',
				'label' => 'Service Fields',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_529f4d416bcfc',
				'label' => 'Columns Type',
				'name' => 'columns_type',
				'type' => 'select',
				'instructions' => 'Select if you want to display posts on 2 columns or 4 columns',
				'choices' => array (
					2 => 2,
					4 => 4,
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0,
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'template-services.php',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_services',
		'title' => 'Services',
		'fields' => array (
			array (
				'key' => 'field_524c6b4131816',
				'label' => 'Services Fields',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_5299d1ad4c65c',
				'label' => 'Service Type',
				'name' => 'service_type',
				'type' => 'radio',
				'instructions' => 'Choose a font awsome or add image for service.',
				'choices' => array (
					'FontAwsome' => 'FontAwsome',
					'Image' => 'Image',
				),
				'other_choice' => 0,
				'save_other_choice' => 0,
				'default_value' => '',
				'layout' => 'horizontal',
			),
			array (
				'key' => 'field_524c6bb431818',
				'label' => 'Font awesome',
				'name' => 'font_awesome',
				'type' => 'select',
				'instructions' => 'Choose the service icon',
				'choices' => array (
					'none' => 'none',
'icon-glass' => '&#xf000;',
'icon-music' => '&#xf001;',
'icon-search' => '&#xf002;',
'icon-envelope-alt' => '&#xf003;',
'icon-heart' => '&#xf004;',
'icon-star' => '&#xf005;',
'icon-star-empty' => '&#xf006;',
'icon-user"' => '&#xf007;',
'icon-film' => '&#xf008;',
'icon-th-large' => '&#xf009;',
'icon-th' => '&#xf00a;',
'icon-th-list' => '&#xf00b;',
'icon-ok' => '&#xf00c;',
'icon-remove' => '&#xf00d;',
'icon-zoom-in' => '&#xf00e;',
'icon-zoom-out' => '&#xf010;',
'icon-off' => '&#xf011;',
'icon-signal' => '&#xf012;',
'icon-cog' => '&#xf013;',
'icon-trash' => '&#xf014;',
'icon-home' => '&#xf015;',
'icon-file-alt' => '&#xf016;',
'icon-time' => '&#xf017;',
'icon-road' => '&#xf018;',
'icon-download-alt' => '&#xf019;',
'icon-download' => '&#xf01a;',
'icon-upload' => '&#xf01b;',
'icon-inbox' => '&#xf01c;',
'icon-play-circle' => '&#xf01d;',
'icon-repeat' => '&#xf01e;',
'icon-refresh' => '&#xf021;',
'icon-list-alt' => '&#xf022;',
'icon-lock' => '&#xf023;',
'icon-flag' => '&#xf024;',
'icon-headphones' => '&#xf025;',
'icon-volume-off' => '&#xf026;',
'icon-volume-down' => '&#xf027;',
'icon-volume-up' => '&#xf028;',
'icon-qrcode' => '&#xf029;',
'icon-barcode' => '&#xf02a;',
'icon-tag' => '&#xf02b;',
'icon-tags' => '&#xf02c;',
'icon-book' => '&#xf02d;',
'icon-bookmark' => '&#xf02e;',
'icon-print' => '&#xf02f;',
'icon-camera' => '&#xf030;',
'icon-font' => '&#xf031;',
'icon-bold' => '&#xf032;',
'icon-italic' => '&#xf033;',
'icon-text-height' => '&#xf034;',
'icon-text-width' => '&#xf035;',
'icon-align-left' => '&#xf036;',
'icon-align-center' => '&#xf037;',
'icon-align-right' => '&#xf038;',
'icon-align-justify' => '&#xf039;',
'icon-list' => '&#xf03a;',
'icon-indent-left' => '&#xf03b;',
'icon-indent-right' => '&#xf03c;',
'icon-facetime-video' => '&#xf03d;',
'icon-picture' => '&#xf03e;',
'icon-pencil' => '&#xf040;',
'icon-map-marker' => '&#xf041;',
'icon-adjust' => '&#xf042;',
'icon-tint' => '&#xf043;',
'icon-edit' => '&#xf044;',
'icon-share' => '&#xf045;',
'icon-check' => '&#xf046;',
'icon-move' => '&#xf047;',
'icon-step-backward' => '&#xf048;',
'icon-fast-backward' => '&#xf049;',
'icon-backward' => '&#xf04a;',
'icon-play' => '&#xf04b;',
'icon-pause' => '&#xf04c;',
'icon-stop' => '&#xf04d;',
'icon-forward' => '&#xf04e;',
'icon-fast-forward' => '&#xf050;',
'icon-step-forward' => '&#xf051;',
'icon-eject' => '&#xf052;',
'icon-chevron-left' => '&#xf053;',
'icon-chevron-right' => '&#xf054;',
'icon-plus-sign' => '&#xf055;',
'icon-minus-sign' => '&#xf056;',
'icon-remove-sign' => '&#xf057;',
'icon-ok-sign' => '&#xf058;',
'icon-question-sign' => '&#xf059;',
'icon-info-sign' => '&#xf05a;',
'icon-screenshot' => '&#xf05b;',
'icon-remove-circle' => '&#xf05c;',
'icon-ok-circle' => '&#xf05d;',
'icon-ban-circle' => '&#xf05e;',
'icon-arrow-left' => '&#xf060;',
'icon-arrow-right' => '&#xf061;',
'icon-arrow-up' => '&#xf062;',
'icon-arrow-down' => '&#xf063;',
'icon-share-alt' => '&#xf064;',
'icon-resize-full' => '&#xf065;',
'icon-resize-small' => '&#xf066;',
'icon-plus' => '&#xf067;',
'icon-minus' => '&#xf068;',
'icon-asterisk' => '&#xf069;',
'icon-exclamation-sign' => '&#xf06a;',
'icon-gift' => '&#xf06b;',
'icon-leaf' => '&#xf06c;',
'icon-fire' => '&#xf06d;',
'icon-eye-open' => '&#xf06e;',
'icon-eye-close' => '&#xf070;',
'icon-warning-sign' => '&#xf071;',
'icon-plane' => '&#xf072;',
'icon-calendar' => '&#xf073;',
'icon-random' => '&#xf074;',
'icon-comment' => '&#xf075;',
'icon-magnet' => '&#xf076;',
'icon-chevron-up' => '&#xf077;',
'icon-chevron-down' => '&#xf078;',
'icon-retweet' => '&#xf079;',
'icon-shopping-cart' => '&#xf07a;',
'icon-folder-close' => '&#xf07b;',
'icon-folder-open' => '&#xf07c;',
'icon-resize-vertical' => '&#xf07d;',
'icon-resize-horizontal' => '&#xf07e;',
'icon-bar-chart' => '&#xf080;',
'icon-twitter-sign' => '&#xf081;',
'icon-facebook-sign' => '&#xf082;',
'icon-camera-retro' => '&#xf083;',
'icon-key' => '&#xf084;',
'icon-cogs' => '&#xf085;',
'icon-comments' => '&#xf086;',
'icon-thumbs-up-alt' => '&#xf087;',
'icon-thumbs-down-alt' => '&#xf088;',
'icon-star-half' => '&#xf089;',
'icon-heart-empty' => '&#xf08a;',
'icon-signout' => '&#xf08b;',
'icon-linkedin-sign' => '&#xf08c;',
'icon-pushpin' => '&#xf08d;',
'icon-external-link' => '&#xf08e;',
'icon-signin' => '&#xf090;',
'icon-trophy' => '&#xf091;',
'icon-github-sign' => '&#xf092;',
'icon-upload-alt' => '&#xf093;',
'icon-lemon' => '&#xf094;',
'icon-phone' => '&#xf095;',
'icon-check-empty' => '&#xf096;',
'icon-bookmark-empty' => '&#xf097;',
'icon-phone-sign' => '&#xf098;',
'icon-twitter' => '&#xf099;',
'icon-facebook' => '&#xf09a;',
'icon-github' => '&#xf09b;',
'icon-unlock' => '&#xf09c;',
'icon-credit-card' => '&#xf09d;',
'icon-rss' => '&#xf09e;',
'icon-hdd' => '&#xf0a0;',
'icon-bullhorn' => '&#xf0a1;',
'icon-bell' => '&#xf0a2;',
'icon-certificate' => '&#xf0a3;',
'icon-hand-right' => '&#xf0a4;',
'icon-hand-left' => '&#xf0a5;',
'icon-hand-up' => '&#xf0a6;',
'icon-hand-down' => '&#xf0a7;',
'icon-circle-arrow-left' => '&#xf0a8;',
'icon-circle-arrow-right' => '&#xf0a9;',
'icon-circle-arrow-up' => '&#xf0aa;',
'icon-circle-arrow-down' => '&#xf0ab;',
'icon-globe' => '&#xf0ac;',
'icon-wrench' => '&#xf0ad;',
'icon-tasks' => '&#xf0ae;',
'icon-filter' => '&#xf0b0;',
'icon-briefcase' => '&#xf0b1;',
'icon-fullscreen' => '&#xf0b2;',
'icon-group' => '&#xf0c0;',
'icon-link' => '&#xf0c1;',
'icon-cloud' => '&#xf0c2;',
'icon-beaker' => '&#xf0c3;',
'icon-cut' => '&#xf0c4;',
'icon-copy' => '&#xf0c5;',
'icon-paper-clip' => '&#xf0c6;',
'icon-save' => '&#xf0c7;',
'icon-sign-blank' => '&#xf0c8;',
'icon-reorder' => '&#xf0c9;',
'icon-list-ul' => '&#xf0ca;',
'icon-list-ol' => '&#xf0cb;',
'icon-strikethrough' => '&#xf0cc;',
'icon-underline' => '&#xf0cd;',
'icon-table' => '&#xf0ce;',
'icon-magic' => '&#xf0d0;',
'icon-truck' => '&#xf0d1;',
'icon-pinterest' => '&#xf0d2;',
'icon-pinterest-sign' => '&#xf0d3;',
'icon-google-plus-sign' => '&#xf0d4;',
'icon-google-plus' => '&#xf0d5;',
'icon-money' => '&#xf0d6;',
'icon-caret-down' => '&#xf0d7;',
'icon-caret-up' => '&#xf0d8;',
'icon-caret-left' => '&#xf0d9;',
'icon-caret-right' => '&#xf0da;',
'icon-columns' => '&#xf0db;',
'icon-sort' => '&#xf0dc;',
'icon-sort-down' => '&#xf0dd;',
'icon-sort-up' => '&#xf0de;',
'icon-envelope' => '&#xf0e0;',
'icon-linkedin' => '&#xf0e1;',
'icon-undo' => '&#xf0e2;',
'icon-legal' => '&#xf0e3;',
'icon-dashboard' => '&#xf0e4;',
'icon-comment-alt' => '&#xf0e5;',
'icon-comments-alt' => '&#xf0e6;',
'icon-bolt' => '&#xf0e7;',
'icon-sitemap' => '&#xf0e8;',
'icon-umbrella' => '&#xf0e9;',
'icon-paste' => '&#xf0ea;',
'icon-lightbulb' => '&#xf0eb;',
'icon-exchange' => '&#xf0ec;',
'icon-cloud-download' => '&#xf0ed;',
'icon-cloud-upload' => '&#xf0ee;',
'icon-user-md' => '&#xf0f0;',
'icon-stethoscope' => '&#xf0f1;',
'icon-suitcase' => '&#xf0f2;',
'icon-bell-alt' => '&#xf0f3;',
'icon-coffee' => '&#xf0f4;',
'icon-food' => '&#xf0f5;',
'icon-file-text-alt' => '&#xf0f6;',
'icon-building' => '&#xf0f7;',
'icon-hospital' => '&#xf0f8;',
'icon-ambulance' => '&#xf0f9;',
'icon-medkit' => '&#xf0fa;',
'icon-fighter-jet' => '&#xf0fb;',
'icon-beer' => '&#xf0fc;',
'icon-h-sign' => '&#xf0fd;',
'icon-plus-sign-alt' => '&#xf0fe;',
'icon-double-angle-left' => '&#xf100;',
'icon-double-angle-right' => '&#xf101;',
'icon-double-angle-up' => '&#xf102;',
'icon-double-angle-down' => '&#xf103;',
'icon-angle-left' => '&#xf104;',
'icon-angle-right' => '&#xf105;',
'icon-angle-up' => '&#xf106;',
'icon-angle-down' => '&#xf107;',
'icon-desktop' => '&#xf108;',
'icon-laptop' => '&#xf109;',
'icon-tablet' => '&#xf10a;',
'icon-mobile-phone' => '&#xf10b;',
'icon-circle-blank' => '&#xf10c;',
'icon-quote-left' => '&#xf10d;',
'icon-quote-right' => '&#xf10e;',
'icon-spinner' => '&#xf110;',
'icon-circle' => '&#xf111;',
'icon-reply' => '&#xf112;',
'icon-github-alt' => '&#xf113;',
'icon-folder-close-alt' => '&#xf114;',
'icon-folder-open-alt' => '&#xf115;',
'icon-expand-alt' => '&#xf116;',
'icon-collapse-alt' => '&#xf117;',
'icon-smile' => '&#xf118;',
'icon-frown' => '&#xf119;',
'icon-meh' => '&#xf11a;',
'icon-gamepad' => '&#xf11b;',
'icon-keyboard' => '&#xf11c;',
'icon-flag-alt' => '&#xf11d;',
'icon-flag-checkered' => '&#xf11e;',
'icon-terminal' => '&#xf120;',
'icon-code' => '&#xf121;',
'icon-reply-all' => '&#xf122;',
'icon-mail-reply-all' => '&#xf122;',
'icon-star-half-empty' => '&#xf123;',
'icon-location-arrow' => '&#xf124;',
'icon-crop' => '&#xf125;',
'icon-code-fork' => '&#xf126;',
'icon-unlink' => '&#xf127;',
'icon-question' => '&#xf128;',
'icon-info' => '&#xf129;',
'icon-exclamation' => '&#xf12a;',
'icon-superscript' => '&#xf12b;',
'icon-subscript' => '&#xf12c;',
'icon-eraser' => '&#xf12d;',
'icon-puzzle-piece' => '&#xf12e;',
'icon-microphone' => '&#xf130;',
'icon-microphone-off' => '&#xf131;',
'icon-shield' => '&#xf132;',
'icon-calendar-empty' => '&#xf133;',
'icon-fire-extinguisher' => '&#xf134;',
'icon-rocket' => '&#xf135;',
'icon-maxcdn' => '&#xf136;',
'icon-chevron-sign-left' => '&#xf137;',
'icon-chevron-sign-right' => '&#xf138;',
'icon-chevron-sign-up' => '&#xf139;',
'icon-chevron-sign-down' => '&#xf13a;',
'icon-html5' => '&#xf13b;',
'icon-css3' => '&#xf13c;',
'icon-anchor' => '&#xf13d;',
'icon-unlock-alt' => '&#xf13e;',
'icon-bullseye' => '&#xf140;',
'icon-ellipsis-horizontal' => '&#xf141;',
'icon-ellipsis-vertical' => '&#xf142;',
'icon-rss-sign' => '&#xf143;',
'icon-play-sign' => '&#xf144;',
'icon-ticket' => '&#xf145;',
'icon-minus-sign-alt' => '&#xf146;',
'icon-check-minus' => '&#xf147;',
'icon-level-up' => '&#xf148;',
'icon-level-down' => '&#xf149;',
'icon-check-sign' => '&#xf14a;',
'icon-edit-sign' => '&#xf14b;',
'icon-external-link-sign' => '&#xf14c;',
'icon-share-sign' => '&#xf14d;',
'icon-compass' => '&#xf14e;',
'icon-collapse' => '&#xf150;',
'icon-collapse-top' => '&#xf151;',
'icon-expand' => '&#xf152;',
'icon-eur' => '&#xf153;',
'icon-gbp' => '&#xf154;',
'icon-usd' => '&#xf155;',
'icon-inr' => '&#xf156;',
'icon-jpy' => '&#xf157;',
'icon-cny' => '&#xf158;',
'icon-krw' => '&#xf159;',
'icon-btc' => '&#xf15a;',
'icon-file' => '&#xf15b;',
'icon-file-text' => '&#xf15c;',
'icon-sort-by-alphabet' => '&#xf15d;',
'icon-sort-by-alphabet-alt' => '&#xf15e;',
'icon-sort-by-attributes' => '&#xf160;',
'icon-sort-by-attributes-alt' => '&#xf161;',
'icon-sort-by-order' => '&#xf162;',
'icon-sort-by-order-alt' => '&#xf163;',
'icon-thumbs-up' => '&#xf164;',
'icon-thumbs-down' => '&#xf165;',
'icon-youtube-sign' => '&#xf166;',
'icon-youtube' => '&#xf167;',
'icon-xing' => '&#xf168;',
'icon-xing-sign' => '&#xf169;',
'icon-youtube-play' => '&#xf16a;',
'icon-dropbox' => '&#xf16b;',
'icon-stackexchange' => '&#xf16c;',
'icon-instagram' => '&#xf16d;',
'icon-flickr' => '&#xf16e;',
'icon-adn' => '&#xf170;',
'icon-bitbucket' => '&#xf171;',
'icon-bitbucket-sign' => '&#xf172;',
'icon-tumblr' => '&#xf173;',
'icon-tumblr-sign' => '&#xf174;',
'icon-long-arrow-down' => '&#xf175;',
'icon-long-arrow-up' => '&#xf176;',
'icon-long-arrow-left' => '&#xf177;',
'icon-long-arrow-right' => '&#xf178;',
'icon-apple' => '&#xf179;',
'icon-windows' => '&#xf17a;',
'icon-android' => '&#xf17b;',
'icon-linux' => '&#xf17c;',
'icon-dribbble' => '&#xf17d;',
'icon-skype' => '&#xf17e;',
'icon-foursquare' => '&#xf180;',
'icon-trello' => '&#xf181;',
'icon-female' => '&#xf182;',
'icon-male' => '&#xf183;',
'icon-gittip' => '&#xf184;',
'icon-sun' => '&#xf185;',
'icon-moon' => '&#xf186;',
'icon-archive' => '&#xf187;',
'icon-bug' => '&#xf188;',
'icon-vk' => '&#xf189;',
'icon-weibo' => '&#xf18a;',
'icon-renren' => '&#xf18b;',
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_5299d1fe43efb',
				'label' => 'Font awesome color',
				'name' => 'font_awesome_color',
				'type' => 'color_picker',
				'instructions' => 'Choose a color for font awsome',
				'default_value' => '',
			),
			array (
				'key' => 'field_5299d17d3a365',
				'label' => 'Image',
				'name' => 'image',
				'type' => 'image',
				'instructions' => 'Add an image for service',
				'save_format' => 'id',
				'preview_size' => 'thumbnail',
				'library' => 'all',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'service_post',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_tesmonials',
		'title' => 'Tesmonials',
		'fields' => array (
			array (
				'key' => 'field_52887dcfbabb5',
				'label' => 'Tesmonials Fields',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_52887ddcbabb6',
				'label' => 'Post on page',
				'name' => 'post_on_page',
				'type' => 'number',
				'instructions' => 'Add the number of post to show per page',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'min' => '',
				'max' => '',
				'step' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'template-testimonials.php',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_testimonial-person',
		'title' => 'Testimonial Person',
		'fields' => array (
			array (
				'key' => 'field_52248f61fbe95',
				'label' => 'Link',
				'name' => 'link',
				'type' => 'text',
				'instructions' => 'Add a link for testmonial',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_52248fbe6e997',
				'label' => 'Position',
				'name' => 'position',
				'type' => 'text',
				'instructions' => 'Position of the person who wrote the testimonial',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'testmonials_post',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_work-1',
		'title' => 'Work 1',
		'fields' => array (
			array (
				'key' => 'field_5249aa7404bd4',
				'label' => 'Work',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_5249a647e87e9',
				'label' => 'Work Title',
				'name' => 'work_title',
				'type' => 'text',
				'instructions' => 'Add the page title. Note: if this field is empty the Menu Title will be displayed',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5249a87d5ffcf',
				'label' => 'Works on page',
				'name' => 'works_on_page',
				'type' => 'number',
				'instructions' => 'Display Works on page load. Note: negative numbers will display 8 Works (galleries)',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'min' => '',
				'max' => '',
				'step' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'template-work1.php',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_work-2',
		'title' => 'Work 2',
		'fields' => array (
			array (
				'key' => 'field_52724da121e6e',
				'label' => 'Work',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_52724d3a070fb',
				'label' => 'Work Title',
				'name' => 'work_title',
				'type' => 'text',
				'instructions' => 'Add page title',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_52724d5a1dfb3',
				'label' => 'Works On Page',
				'name' => 'works_on_page',
				'type' => 'number',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'min' => '',
				'max' => '',
				'step' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'template-work2.php',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_works-fields',
		'title' => 'Works Fields',
		'fields' => array (
			array (
				'key' => 'field_523069071b459',
				'label' => 'Work Type',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_5270d648c6953',
				'label' => 'Type',
				'name' => 'type',
				'type' => 'radio',
				'instructions' => 'Choose one of the work post types default is none (which displays the featured image).',
				'choices' => array (
					'none' => 'None',
					'video' => 'Video',
					'slider' => 'Slider',
				),
				'other_choice' => 0,
				'save_other_choice' => 0,
				'default_value' => '',
				'layout' => 'horizontal',
			),
			array (
				'key' => 'field_5270d65dc6954',
				'label' => 'Video Host',
				'name' => 'video_host',
				'type' => 'radio',
				'instructions' => 'Choose your video source.',
				'choices' => array (
					'youtube' => 'Youtube',
					'vimeo' => 'Vimeo',
					'selfhosted' => 'Self Hosted',
				),
				'other_choice' => 0,
				'save_other_choice' => 0,
				'default_value' => '',
				'layout' => 'horizontal',
			),
			array (
				'key' => 'field_5270d718c6955',
				'label' => 'Video ID',
				'name' => 'video_id',
				'type' => 'text',
				'instructions' => 'Set	your video id.
	Ex.:
	Youtube: TBXv37PFcAQ
	Vimeo: 877053',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5270d725c6956',
				'label' => 'Video File',
				'name' => 'video_file',
				'type' => 'file',
				'instructions' => 'Click here to upload video file.',
				'save_format' => 'id',
				'library' => 'all',
			),
			array (
				'key' => 'field_523069161b45a',
				'label' => 'Slider',
				'name' => 'slider',
				'type' => 'repeater',
				'instructions' => 'Here you add slider images',
				'sub_fields' => array (
					array (
						'key' => 'field_523069411b45b',
						'label' => 'Image',
						'name' => 'image',
						'type' => 'image',
						'column_width' => '',
						'save_format' => 'id',
						'preview_size' => 'home2-featured',
						'library' => 'all',
					),
				),
				'row_min' => 0,
				'row_limit' => '',
				'layout' => 'table',
				'button_label' => 'Add Row',
			),
			array (
				'key' => 'field_5270fa6f70eb6',
				'label' => 'Work Post Options',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_5270fa8070eb7',
				'label' => 'Live Demo',
				'name' => 'live_demo',
				'type' => 'text',
				'instructions' => 'Add link if any as live demo',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'work_post',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
}
?>